/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.pinecone;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.google.protobuf.util.JsonFormat;
import io.pinecone.clients.Pinecone;
import io.pinecone.commons.IndexInterface;
import io.pinecone.proto.QueryRequest;
import io.pinecone.unsigned_indices_model.QueryResponseWithUnsignedIndices;
import io.pinecone.unsigned_indices_model.VectorWithUnsignedIndices;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentMetadata;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.model.EmbeddingUtils;
import org.springframework.ai.observation.conventions.VectorStoreProvider;
import org.springframework.ai.vectorstore.AbstractVectorStoreBuilder;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionConverter;
import org.springframework.ai.vectorstore.filter.converter.PineconeFilterExpressionConverter;
import org.springframework.ai.vectorstore.observation.AbstractObservationVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PineconeVectorStore
extends AbstractObservationVectorStore {
    public static final String CONTENT_FIELD_NAME = "document_content";
    public final FilterExpressionConverter filterExpressionConverter = new PineconeFilterExpressionConverter();
    private final String pineconeNamespace;
    private final String pineconeIndexName;
    private final String pineconeContentFieldName;
    private final String pineconeDistanceMetadataFieldName;
    private final Pinecone pinecone;
    private final ObjectMapper objectMapper;
    private static final Logger logger = LoggerFactory.getLogger(PineconeVectorStore.class);

    protected PineconeVectorStore(Builder builder) {
        super((AbstractVectorStoreBuilder)builder);
        Assert.hasText((String)builder.apiKey, (String)"ApiKey must not be null or empty");
        Assert.hasText((String)builder.indexName, (String)"IndexName must not be null or empty");
        this.pineconeNamespace = builder.namespace;
        this.pineconeIndexName = builder.indexName;
        this.pineconeContentFieldName = builder.contentFieldName;
        this.pineconeDistanceMetadataFieldName = builder.distanceMetadataFieldName;
        this.pinecone = new Pinecone.Builder(builder.apiKey).build();
        this.objectMapper = new ObjectMapper();
    }

    public static Builder.BuilderWithApiKey builder(EmbeddingModel embeddingModel) {
        return Builder.StepBuilder.start(embeddingModel);
    }

    public void add(List<Document> documents, String namespace) {
        List embeddings = this.embeddingModel.embed(documents, EmbeddingOptions.builder().build(), this.batchingStrategy);
        ArrayList<VectorWithUnsignedIndices> upsertVectors = new ArrayList<VectorWithUnsignedIndices>();
        for (Document document : documents) {
            upsertVectors.add(IndexInterface.buildUpsertVectorWithUnsignedIndices((String)document.getId(), (List)EmbeddingUtils.toList((float[])((float[])embeddings.get(documents.indexOf(document)))), null, null, (Struct)this.metadataToStruct(document)));
        }
        this.pinecone.getIndexConnection(this.pineconeIndexName).upsert(upsertVectors, namespace);
    }

    public void doAdd(List<Document> documents) {
        this.add(documents, this.pineconeNamespace);
    }

    private Struct metadataToStruct(Document document) {
        try {
            Struct.Builder structBuilder = Struct.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(this.objectMapper.writeValueAsString((Object)document.getMetadata()), (Message.Builder)structBuilder);
            structBuilder.putFields(this.pineconeContentFieldName, this.contentValue(document));
            return structBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Value contentValue(Document document) {
        return Value.newBuilder().setStringValue(Objects.requireNonNullElse(document.getText(), "")).build();
    }

    public void delete(List<String> documentIds, String namespace) {
        this.pinecone.getIndexConnection(this.pineconeIndexName).delete(documentIds, false, namespace, null);
    }

    public void doDelete(List<String> documentIds) {
        this.delete(documentIds, this.pineconeNamespace);
    }

    public List<Document> similaritySearch(SearchRequest request, String namespace) {
        String nativeExpressionFilters = request.getFilterExpression() != null ? this.filterExpressionConverter.convertExpression(request.getFilterExpression()) : "";
        float[] queryEmbedding = this.embeddingModel.embed(request.getQuery());
        QueryRequest.Builder queryRequestBuilder = QueryRequest.newBuilder().addAllVector((Iterable)EmbeddingUtils.toList((float[])queryEmbedding)).setTopK(request.getTopK()).setIncludeMetadata(true).setNamespace(namespace);
        if (StringUtils.hasText((String)nativeExpressionFilters)) {
            queryRequestBuilder.setFilter(this.metadataFiltersToStruct(nativeExpressionFilters));
        }
        QueryResponseWithUnsignedIndices queryResponse = this.pinecone.getIndexConnection(this.pineconeIndexName).queryByVector(request.getTopK(), EmbeddingUtils.toList((float[])queryEmbedding), namespace, this.metadataFiltersToStruct(nativeExpressionFilters), false, true);
        return queryResponse.getMatchesList().stream().filter(scoredVector -> (double)scoredVector.getScore() >= request.getSimilarityThreshold()).map(scoredVector -> {
            String id = scoredVector.getId();
            Struct metadataStruct = scoredVector.getMetadata();
            String content = metadataStruct.getFieldsOrThrow(this.pineconeContentFieldName).getStringValue();
            Map<String, Object> metadata = this.extractMetadata(metadataStruct);
            metadata.put(this.pineconeDistanceMetadataFieldName, Float.valueOf(1.0f - scoredVector.getScore()));
            return Document.builder().id(id).text(content).metadata(metadata).score(Double.valueOf(scoredVector.getScore())).build();
        }).toList();
    }

    protected void doDelete(Filter.Expression filterExpression) {
        Assert.notNull((Object)filterExpression, (String)"Filter expression must not be null");
        try {
            SearchRequest searchRequest = SearchRequest.builder().query("").filterExpression(filterExpression).topK(10000).similarityThresholdAll().build();
            List<Document> matchingDocs = this.similaritySearch(searchRequest, this.pineconeNamespace);
            if (!matchingDocs.isEmpty()) {
                List<String> idsToDelete = matchingDocs.stream().map(Document::getId).collect(Collectors.toList());
                this.delete(idsToDelete, this.pineconeNamespace);
                logger.debug("Deleted {} documents matching filter expression", (Object)idsToDelete.size());
            }
        }
        catch (Exception e) {
            logger.error("Failed to delete documents by filter", (Throwable)e);
            throw new IllegalStateException("Failed to delete documents by filter", e);
        }
    }

    public List<Document> doSimilaritySearch(SearchRequest request) {
        return this.similaritySearch(request, this.pineconeNamespace);
    }

    private Struct metadataFiltersToStruct(String metadataFilters) {
        try {
            Struct.Builder structBuilder = Struct.newBuilder();
            JsonFormat.parser().ignoringUnknownFields().merge(metadataFilters, (Message.Builder)structBuilder);
            return structBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> extractMetadata(Struct metadataStruct) {
        try {
            String json = JsonFormat.printer().print((MessageOrBuilder)metadataStruct);
            Map metadata = (Map)this.objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
            metadata.remove(this.pineconeContentFieldName);
            return metadata;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public VectorStoreObservationContext.Builder createObservationContextBuilder(String operationName) {
        return VectorStoreObservationContext.builder((String)VectorStoreProvider.PINECONE.value(), (String)operationName).collectionName(this.pineconeIndexName).dimensions(Integer.valueOf(this.embeddingModel.dimensions())).namespace(this.pineconeNamespace).fieldName(this.pineconeContentFieldName);
    }

    public <T> Optional<T> getNativeClient() {
        Pinecone client = this.pinecone;
        return Optional.of(client);
    }

    public static class Builder
    extends AbstractVectorStoreBuilder<Builder> {
        private final String apiKey;
        private final String indexName;
        private String namespace = "";
        private String contentFieldName = "document_content";
        private String distanceMetadataFieldName = DocumentMetadata.DISTANCE.value();

        private Builder(EmbeddingModel embeddingModel, String apiKey, String indexName) {
            super(embeddingModel);
            this.apiKey = apiKey;
            this.indexName = indexName;
        }

        public Builder namespace(@Nullable String namespace) {
            this.namespace = namespace != null ? namespace : "";
            return this;
        }

        public Builder contentFieldName(@Nullable String contentFieldName) {
            this.contentFieldName = contentFieldName != null ? contentFieldName : PineconeVectorStore.CONTENT_FIELD_NAME;
            return this;
        }

        public Builder distanceMetadataFieldName(@Nullable String distanceMetadataFieldName) {
            this.distanceMetadataFieldName = distanceMetadataFieldName != null ? distanceMetadataFieldName : DocumentMetadata.DISTANCE.value();
            return this;
        }

        public PineconeVectorStore build() {
            return new PineconeVectorStore(this);
        }

        public static class StepBuilder {
            static BuilderWithApiKey start(EmbeddingModel embeddingModel) {
                Assert.notNull((Object)embeddingModel, (String)"EmbeddingModel must not be null");
                return new ApiKeyStep(embeddingModel);
            }

            private record ApiKeyStep(EmbeddingModel embeddingModel) implements BuilderWithApiKey
            {
                @Override
                public BuilderWithIndexName apiKey(String apiKey) {
                    Assert.hasText((String)apiKey, (String)"ApiKey must not be null or empty");
                    return new IndexNameStep(this.embeddingModel, apiKey);
                }
            }

            private record IndexNameStep(EmbeddingModel embeddingModel, String apiKey) implements BuilderWithIndexName
            {
                @Override
                public Builder indexName(String indexName) {
                    Assert.hasText((String)indexName, (String)"IndexName must not be null or empty");
                    return new Builder(this.embeddingModel, this.apiKey, indexName);
                }
            }
        }

        public static interface BuilderWithIndexName {
            public Builder indexName(String var1);
        }

        public static interface BuilderWithApiKey {
            public BuilderWithIndexName apiKey(String var1);
        }
    }
}

