/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.reader.pdf.layout;

import org.springframework.ai.reader.pdf.layout.Character;

class TextLine {
    private static final char SPACE_CHARACTER = ' ';
    private int lineLength;
    private String line = "";
    private int lastIndex;

    public TextLine(int lineLength) {
        this.lineLength = lineLength / 4;
        this.completeLineWithSpaces();
    }

    public void writeCharacterAtIndex(Character character) {
        character.setIndex(this.computeIndexForCharacter(character));
        int index = character.getIndex();
        char characterValue = character.getCharacterValue();
        if (this.indexIsInBounds(index) && this.line.charAt(index) == ' ') {
            this.line = this.line.substring(0, index) + characterValue + this.line.substring(index + 1, this.getLineLength());
        }
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public String getLine() {
        return this.line;
    }

    private int computeIndexForCharacter(Character character) {
        int index = character.getIndex();
        boolean isCharacterPartOfPreviousWord = character.isCharacterPartOfPreviousWord();
        boolean isCharacterAtTheBeginningOfNewLine = character.isCharacterAtTheBeginningOfNewLine();
        boolean isCharacterCloseToPreviousWord = character.isCharacterCloseToPreviousWord();
        if (!this.indexIsInBounds(index)) {
            return -1;
        }
        if (isCharacterPartOfPreviousWord && !isCharacterAtTheBeginningOfNewLine) {
            index = this.findMinimumIndexWithSpaceCharacterFromIndex(index);
        } else if (isCharacterCloseToPreviousWord) {
            index = this.line.charAt(index) != ' ' ? ++index : this.findMinimumIndexWithSpaceCharacterFromIndex(index) + 1;
        }
        index = this.getNextValidIndex(index, isCharacterPartOfPreviousWord);
        return index;
    }

    private boolean isSpaceCharacterAtIndex(int index) {
        return this.line.charAt(index) != ' ';
    }

    private boolean isNewIndexGreaterThanLastIndex(int index) {
        int lastIndex = this.getLastIndex();
        return index > lastIndex;
    }

    private int getNextValidIndex(int index, boolean isCharacterPartOfPreviousWord) {
        int nextValidIndex = index;
        int lastIndex = this.getLastIndex();
        if (!this.isNewIndexGreaterThanLastIndex(index)) {
            nextValidIndex = lastIndex + 1;
        }
        if (!isCharacterPartOfPreviousWord && this.isSpaceCharacterAtIndex(index - 1)) {
            ++nextValidIndex;
        }
        this.setLastIndex(nextValidIndex);
        return nextValidIndex;
    }

    private int findMinimumIndexWithSpaceCharacterFromIndex(int index) {
        int newIndex;
        for (newIndex = index; newIndex >= 0 && this.line.charAt(newIndex) == ' '; --newIndex) {
        }
        return newIndex + 1;
    }

    private boolean indexIsInBounds(int index) {
        return index >= 0 && index < this.lineLength;
    }

    private void completeLineWithSpaces() {
        for (int i = 0; i < this.getLineLength(); ++i) {
            this.line = this.line + " ";
        }
    }

    private int getLastIndex() {
        return this.lastIndex;
    }

    private void setLastIndex(int lastIndex) {
        this.lastIndex = lastIndex;
    }
}

