/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.opensearch;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.InlineScript;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.DeleteByQueryRequest;
import org.opensearch.client.opensearch.core.DeleteByQueryResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.bulk.DeleteOperation;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.CreateIndexResponse;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentMetadata;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.EmbeddingOptionsBuilder;
import org.springframework.ai.observation.conventions.VectorStoreProvider;
import org.springframework.ai.observation.conventions.VectorStoreSimilarityMetric;
import org.springframework.ai.vectorstore.AbstractVectorStoreBuilder;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionConverter;
import org.springframework.ai.vectorstore.observation.AbstractObservationVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.ai.vectorstore.opensearch.OpenSearchAiSearchFilterExpressionConverter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class OpenSearchVectorStore
extends AbstractObservationVectorStore
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(OpenSearchVectorStore.class);
    public static final String COSINE_SIMILARITY_FUNCTION = "cosinesimil";
    public static final String DEFAULT_INDEX_NAME = "spring-ai-document-index";
    public static final String DEFAULT_MAPPING_EMBEDDING_TYPE_KNN_VECTOR_DIMENSION = "{\n\t\"properties\":{\n\t\t\"embedding\":{\n\t\t\t\"type\":\"knn_vector\",\n\t\t\t\"dimension\":%s\n\t\t}\n\t}\n}\n";
    private final OpenSearchClient openSearchClient;
    private final String index;
    private final FilterExpressionConverter filterExpressionConverter;
    private final String mappingJson;
    private final boolean initializeSchema;
    private String similarityFunction;

    protected OpenSearchVectorStore(Builder builder) {
        super((AbstractVectorStoreBuilder)builder);
        Assert.notNull((Object)builder.openSearchClient, (String)"OpenSearchClient must not be null");
        this.openSearchClient = builder.openSearchClient;
        this.index = builder.index;
        this.mappingJson = builder.mappingJson;
        this.filterExpressionConverter = builder.filterExpressionConverter;
        this.similarityFunction = builder.similarityFunction;
        this.initializeSchema = builder.initializeSchema;
    }

    public static Builder builder(OpenSearchClient openSearchClient, EmbeddingModel embeddingModel) {
        return new Builder(openSearchClient, embeddingModel);
    }

    public OpenSearchVectorStore withSimilarityFunction(String similarityFunction) {
        this.similarityFunction = similarityFunction;
        return this;
    }

    public void doAdd(List<Document> documents) {
        List embedding = this.embeddingModel.embed(documents, EmbeddingOptionsBuilder.builder().build(), this.batchingStrategy);
        BulkRequest.Builder bulkRequestBuilder = new BulkRequest.Builder();
        for (Document document : documents) {
            OpenSearchDocument openSearchDocument = new OpenSearchDocument(document.getId(), document.getText(), document.getMetadata(), (float[])embedding.get(documents.indexOf(document)));
            bulkRequestBuilder.operations(op -> op.index(idx -> ((IndexOperation.Builder)((IndexOperation.Builder)idx.index(this.index)).id(openSearchDocument.id())).document((Object)openSearchDocument)));
        }
        this.bulkRequest(bulkRequestBuilder.build());
    }

    public void doDelete(List<String> idList) {
        BulkRequest.Builder bulkRequestBuilder = new BulkRequest.Builder();
        for (String id : idList) {
            bulkRequestBuilder.operations(op -> op.delete(idx -> (ObjectBuilder)((DeleteOperation.Builder)idx.index(this.index)).id(id)));
        }
        if (this.bulkRequest(bulkRequestBuilder.build()).errors()) {
            throw new IllegalStateException("Delete operation failed");
        }
    }

    private BulkResponse bulkRequest(BulkRequest bulkRequest) {
        try {
            return this.openSearchClient.bulk(bulkRequest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doDelete(Filter.Expression filterExpression) {
        Assert.notNull((Object)filterExpression, (String)"Filter expression must not be null");
        try {
            String filterStr = this.filterExpressionConverter.convertExpression(filterExpression);
            DeleteByQueryRequest request = new DeleteByQueryRequest.Builder().index(this.index, new String[0]).query(q -> q.queryString(qs -> qs.query(filterStr))).build();
            DeleteByQueryResponse response = this.openSearchClient.deleteByQuery(request);
            logger.debug("Deleted " + response.deleted() + " documents matching filter expression");
            if (!response.failures().isEmpty()) {
                throw new IllegalStateException("Failed to delete some documents: " + String.valueOf(response.failures()));
            }
        }
        catch (Exception e) {
            logger.error("Failed to delete documents by filter: {}", (Object)e.getMessage());
            throw new IllegalStateException("Failed to delete documents by filter", e);
        }
    }

    public List<Document> doSimilaritySearch(SearchRequest searchRequest) {
        Assert.notNull((Object)searchRequest, (String)"The search request must not be null.");
        return this.similaritySearch(this.embeddingModel.embed(searchRequest.getQuery()), searchRequest.getTopK(), searchRequest.getSimilarityThreshold(), searchRequest.getFilterExpression());
    }

    public List<Document> similaritySearch(float[] embedding, int topK, double similarityThreshold, Filter.Expression filterExpression) {
        return this.similaritySearch(new SearchRequest.Builder().query(this.getOpenSearchSimilarityQuery(embedding, filterExpression)).index(this.index, new String[0]).sort(sortOptionsBuilder -> sortOptionsBuilder.score(scoreSortBuilder -> scoreSortBuilder.order(SortOrder.Desc))).size(Integer.valueOf(topK)).minScore(Double.valueOf(similarityThreshold)).build());
    }

    private Query getOpenSearchSimilarityQuery(float[] embedding, Filter.Expression filterExpression) {
        return Query.of(queryBuilder -> queryBuilder.scriptScore(scriptScoreQueryBuilder -> {
            scriptScoreQueryBuilder.query(queryBuilder2 -> queryBuilder2.queryString(queryStringQuerybuilder -> queryStringQuerybuilder.query(this.getOpenSearchQueryString(filterExpression)))).script(scriptBuilder -> scriptBuilder.inline(inlineScriptBuilder -> (ObjectBuilder)((InlineScript.Builder)((InlineScript.Builder)inlineScriptBuilder.source("knn_score").lang("knn").params("field", JsonData.of((Object)"embedding"))).params("query_value", JsonData.of((Object)embedding))).params("space_type", JsonData.of((Object)this.similarityFunction))));
            return this.similarityFunction.equals(COSINE_SIMILARITY_FUNCTION) ? (ObjectBuilder)scriptScoreQueryBuilder.boost(Float.valueOf(0.5f)) : scriptScoreQueryBuilder;
        }));
    }

    private String getOpenSearchQueryString(Filter.Expression filterExpression) {
        return Objects.isNull(filterExpression) ? "*" : this.filterExpressionConverter.convertExpression(filterExpression);
    }

    private List<Document> similaritySearch(org.opensearch.client.opensearch.core.SearchRequest searchRequest) {
        try {
            return this.openSearchClient.search(searchRequest, Document.class).hits().hits().stream().map(this::toDocument).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Document toDocument(Hit<Document> hit) {
        Document document = (Document)hit.source();
        Document.Builder documentBuilder = document.mutate();
        if (hit.score() != null) {
            documentBuilder.metadata(DocumentMetadata.DISTANCE.value(), (Object)Float.valueOf(1.0f - hit.score().floatValue()));
            documentBuilder.score(hit.score());
        }
        return documentBuilder.build();
    }

    public boolean exists(String targetIndex) {
        try {
            BooleanResponse response = this.openSearchClient.indices().exists(existRequestBuilder -> existRequestBuilder.index(targetIndex, new String[0]));
            return response.value();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CreateIndexResponse createIndexMapping(String index, String mappingJson) {
        JsonpMapper jsonpMapper = ((OpenSearchTransport)this.openSearchClient._transport()).jsonpMapper();
        try {
            return this.openSearchClient.indices().create(new CreateIndexRequest.Builder().index(index).settings(settingsBuilder -> settingsBuilder.knn(Boolean.valueOf(true))).mappings((TypeMapping)TypeMapping._DESERIALIZER.deserialize(jsonpMapper.jsonProvider().createParser((Reader)new StringReader(mappingJson)), jsonpMapper)).build());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void afterPropertiesSet() {
        if (this.initializeSchema && !this.exists(this.index)) {
            this.createIndexMapping(this.index, String.format(this.mappingJson, this.embeddingModel.dimensions()));
        }
    }

    public VectorStoreObservationContext.Builder createObservationContextBuilder(String operationName) {
        return VectorStoreObservationContext.builder((String)VectorStoreProvider.OPENSEARCH.value(), (String)operationName).collectionName(this.index).dimensions(Integer.valueOf(this.embeddingModel.dimensions())).similarityMetric(this.getSimilarityFunction());
    }

    private String getSimilarityFunction() {
        if (COSINE_SIMILARITY_FUNCTION.equalsIgnoreCase(this.similarityFunction)) {
            return VectorStoreSimilarityMetric.COSINE.value();
        }
        if ("l2".equalsIgnoreCase(this.similarityFunction)) {
            return VectorStoreSimilarityMetric.EUCLIDEAN.value();
        }
        return this.similarityFunction;
    }

    public <T> Optional<T> getNativeClient() {
        OpenSearchClient client = this.openSearchClient;
        return Optional.of(client);
    }

    public static class Builder
    extends AbstractVectorStoreBuilder<Builder> {
        private final OpenSearchClient openSearchClient;
        private String index = "spring-ai-document-index";
        private String mappingJson = "{\n\t\"properties\":{\n\t\t\"embedding\":{\n\t\t\t\"type\":\"knn_vector\",\n\t\t\t\"dimension\":%s\n\t\t}\n\t}\n}\n";
        private boolean initializeSchema = false;
        private FilterExpressionConverter filterExpressionConverter = new OpenSearchAiSearchFilterExpressionConverter();
        private String similarityFunction = "cosinesimil";

        private Builder(OpenSearchClient openSearchClient, EmbeddingModel embeddingModel) {
            super(embeddingModel);
            Assert.notNull((Object)openSearchClient, (String)"OpenSearchClient must not be null");
            this.openSearchClient = openSearchClient;
        }

        public Builder index(String index) {
            Assert.hasText((String)index, (String)"index must not be null or empty");
            this.index = index;
            return this;
        }

        public Builder mappingJson(String mappingJson) {
            Assert.hasText((String)mappingJson, (String)"mappingJson must not be null or empty");
            this.mappingJson = mappingJson;
            return this;
        }

        public Builder initializeSchema(boolean initializeSchema) {
            this.initializeSchema = initializeSchema;
            return this;
        }

        public Builder filterExpressionConverter(FilterExpressionConverter converter) {
            Assert.notNull((Object)converter, (String)"filterExpressionConverter must not be null");
            this.filterExpressionConverter = converter;
            return this;
        }

        public Builder similarityFunction(String similarityFunction) {
            Assert.hasText((String)similarityFunction, (String)"similarityFunction must not be null or empty");
            this.similarityFunction = similarityFunction;
            return this;
        }

        public OpenSearchVectorStore build() {
            return new OpenSearchVectorStore(this);
        }
    }

    public record OpenSearchDocument(String id, String content, Map<String, Object> metadata, float[] embedding) {
    }
}

