/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.audio.tts.Speech;
import org.springframework.ai.audio.tts.TextToSpeechModel;
import org.springframework.ai.audio.tts.TextToSpeechOptions;
import org.springframework.ai.audio.tts.TextToSpeechPrompt;
import org.springframework.ai.audio.tts.TextToSpeechResponse;
import org.springframework.ai.audio.tts.TextToSpeechResponseMetadata;
import org.springframework.ai.chat.metadata.RateLimit;
import org.springframework.ai.openai.OpenAiAudioSpeechOptions;
import org.springframework.ai.openai.api.OpenAiAudioApi;
import org.springframework.ai.openai.metadata.audio.OpenAiAudioSpeechResponseMetadata;
import org.springframework.ai.openai.metadata.support.OpenAiResponseHeaderExtractor;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class OpenAiAudioSpeechModel
implements TextToSpeechModel {
    private static final Double SPEED = 1.0;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final OpenAiAudioSpeechOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final OpenAiAudioApi audioApi;

    public OpenAiAudioSpeechModel(OpenAiAudioApi audioApi) {
        this(audioApi, OpenAiAudioSpeechOptions.builder().model(OpenAiAudioApi.TtsModel.GPT_4_O_MINI_TTS.getValue()).responseFormat(OpenAiAudioApi.SpeechRequest.AudioResponseFormat.MP3).voice(OpenAiAudioApi.SpeechRequest.Voice.ALLOY.getValue()).speed(SPEED).build());
    }

    public OpenAiAudioSpeechModel(OpenAiAudioApi audioApi, OpenAiAudioSpeechOptions options) {
        this(audioApi, options, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public OpenAiAudioSpeechModel(OpenAiAudioApi audioApi, OpenAiAudioSpeechOptions options, RetryTemplate retryTemplate) {
        Assert.notNull((Object)audioApi, (String)"OpenAiAudioApi must not be null");
        Assert.notNull((Object)options, (String)"OpenAiSpeechOptions must not be null");
        Assert.notNull((Object)options, (String)"RetryTemplate must not be null");
        this.audioApi = audioApi;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
    }

    public byte[] call(String text) {
        TextToSpeechPrompt prompt = new TextToSpeechPrompt(text);
        return this.call(prompt).getResult().getOutput();
    }

    public TextToSpeechResponse call(TextToSpeechPrompt prompt) {
        OpenAiAudioApi.SpeechRequest speechRequest = this.createRequest(prompt);
        ResponseEntity speechEntity = (ResponseEntity)RetryUtils.execute((RetryTemplate)this.retryTemplate, () -> this.audioApi.createSpeech(speechRequest));
        byte[] speech = (byte[])speechEntity.getBody();
        if (speech == null) {
            this.logger.warn("No speech response returned for speechRequest: {}", (Object)speechRequest);
            return new TextToSpeechResponse(List.of(new Speech(new byte[0])));
        }
        RateLimit rateLimits = OpenAiResponseHeaderExtractor.extractAiResponseHeaders(speechEntity);
        return new TextToSpeechResponse(List.of(new Speech(speech)), (TextToSpeechResponseMetadata)new OpenAiAudioSpeechResponseMetadata(rateLimits));
    }

    public Flux<TextToSpeechResponse> stream(TextToSpeechPrompt prompt) {
        OpenAiAudioApi.SpeechRequest speechRequest = this.createRequest(prompt);
        Flux speechEntity = (Flux)RetryUtils.execute((RetryTemplate)this.retryTemplate, () -> this.audioApi.stream(speechRequest));
        return speechEntity.map(entity -> new TextToSpeechResponse(List.of(new Speech((byte[])entity.getBody())), (TextToSpeechResponseMetadata)new OpenAiAudioSpeechResponseMetadata(OpenAiResponseHeaderExtractor.extractAiResponseHeaders(entity))));
    }

    private OpenAiAudioApi.SpeechRequest createRequest(TextToSpeechPrompt prompt) {
        OpenAiAudioSpeechOptions openAiAudioSpeechOptions;
        TextToSpeechOptions textToSpeechOptions = prompt.getOptions();
        OpenAiAudioSpeechOptions runtimeOptions = textToSpeechOptions instanceof OpenAiAudioSpeechOptions ? (openAiAudioSpeechOptions = (OpenAiAudioSpeechOptions)textToSpeechOptions) : null;
        OpenAiAudioSpeechOptions options = runtimeOptions != null ? this.merge(runtimeOptions, this.defaultOptions) : this.defaultOptions;
        String input = StringUtils.hasText((String)options.getInput()) ? options.getInput() : prompt.getInstructions().getText();
        OpenAiAudioApi.SpeechRequest.Builder requestBuilder = OpenAiAudioApi.SpeechRequest.builder().model(options.getModel()).input(input).voice(options.getVoice()).responseFormat(options.getResponseFormat()).speed(options.getSpeed());
        return requestBuilder.build();
    }

    public TextToSpeechOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    private OpenAiAudioSpeechOptions merge(OpenAiAudioSpeechOptions source, OpenAiAudioSpeechOptions target) {
        OpenAiAudioSpeechOptions.Builder mergedBuilder = OpenAiAudioSpeechOptions.builder();
        mergedBuilder.model(source.getModel() != null ? source.getModel() : target.getModel());
        mergedBuilder.input(source.getInput() != null ? source.getInput() : target.getInput());
        mergedBuilder.voice(source.getVoice() != null ? source.getVoice() : target.getVoice());
        mergedBuilder.responseFormat(source.getResponseFormat() != null ? source.getResponseFormat() : target.getResponseFormat());
        mergedBuilder.speed(source.getSpeed() != null ? source.getSpeed() : target.getSpeed());
        return mergedBuilder.build();
    }
}

