/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriBuilder;

public class OpenAiFileApi {
    private final RestClient restClient;

    public OpenAiFileApi(String baseUrl, ApiKey apiKey, HttpHeaders headers, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        Consumer<HttpHeaders> authHeaders = h -> h.addAll(headers);
        this.restClient = restClientBuilder.clone().baseUrl(baseUrl).defaultHeaders(authHeaders).defaultStatusHandler(responseErrorHandler).defaultRequest(requestHeadersSpec -> {
            if (!(apiKey instanceof NoopApiKey)) {
                requestHeadersSpec.header("Authorization", new String[]{"Bearer " + apiKey.getValue()});
            }
        }).build();
    }

    public OpenAiFileApi(RestClient restClient) {
        this.restClient = restClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ResponseEntity<FileObject> uploadFile(final UploadFileRequest uploadFileRequest) {
        LinkedMultiValueMap multipartBody = new LinkedMultiValueMap();
        multipartBody.add((Object)"file", (Object)new ByteArrayResource(this, uploadFileRequest.file()){
            final /* synthetic */ OpenAiFileApi this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            public String getFilename() {
                return uploadFileRequest.fileName();
            }
        });
        multipartBody.add((Object)"purpose", (Object)uploadFileRequest.purpose());
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/v1/files", new Object[0])).body((Object)multipartBody).retrieve().toEntity(FileObject.class);
    }

    public ResponseEntity<FileObjectResponse> listFiles(ListFileRequest listFileRequest) {
        return this.restClient.get().uri(uriBuilder -> {
            UriBuilder builder = uriBuilder.path("/v1/files");
            if (null != listFileRequest.after()) {
                builder = builder.queryParam("after", new Object[]{listFileRequest.after()});
            }
            if (null != listFileRequest.limit()) {
                builder = builder.queryParam("limit", new Object[]{listFileRequest.limit()});
            }
            if (null != listFileRequest.order()) {
                builder = builder.queryParam("order", new Object[]{listFileRequest.order()});
            }
            if (null != listFileRequest.purpose()) {
                builder = builder.queryParam("purpose", new Object[]{listFileRequest.purpose()});
            }
            return builder.build(new Object[0]);
        }).retrieve().toEntity(FileObjectResponse.class);
    }

    public ResponseEntity<FileObject> retrieveFile(String fileId) {
        return this.restClient.get().uri("/v1/files/%s".formatted(fileId), new Object[0]).retrieve().toEntity(FileObject.class);
    }

    public ResponseEntity<DeleteFileResponse> deleteFile(String fileId) {
        return this.restClient.delete().uri("/v1/files/%s".formatted(fileId), new Object[0]).retrieve().toEntity(DeleteFileResponse.class);
    }

    public ResponseEntity<String> retrieveFileContent(String fileId) {
        return this.restClient.get().uri("/v1/files/%s/content".formatted(fileId), new Object[0]).retrieve().toEntity(String.class);
    }

    public static final class Builder {
        private String baseUrl = "https://api.openai.com";
        private ApiKey apiKey;
        private HttpHeaders headers = new HttpHeaders();
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        public Builder baseUrl(String baseUrl) {
            Assert.hasText((String)baseUrl, (String)"baseUrl cannot be null or empty");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiKey(ApiKey apiKey) {
            Assert.notNull((Object)apiKey, (String)"apiKey cannot be null");
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            Assert.notNull((Object)simpleApiKey, (String)"simpleApiKey cannot be null");
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder headers(HttpHeaders headers) {
            Assert.notNull((Object)headers, (String)"headers cannot be null");
            this.headers = headers;
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"restClientBuilder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"responseErrorHandler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public OpenAiFileApi build() {
            Assert.notNull((Object)this.apiKey, (String)"apiKey must be set");
            return new OpenAiFileApi(this.baseUrl, this.apiKey, this.headers, this.restClientBuilder, this.responseErrorHandler);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record UploadFileRequest(@JsonProperty(value="file") byte[] file, @JsonProperty(value="fileName") String fileName, @JsonProperty(value="purpose") String purpose) {
        public static Builder builder() {
            return new Builder();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UploadFileRequest)) {
                return false;
            }
            UploadFileRequest that = (UploadFileRequest)o;
            return Arrays.equals(this.file, that.file) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.purpose, that.purpose);
        }

        @Override
        public int hashCode() {
            int result = Arrays.hashCode(this.file);
            result = 31 * result + Objects.hashCode(this.fileName);
            result = 31 * result + Objects.hashCode(this.purpose);
            return result;
        }

        @Override
        public String toString() {
            return "UploadFileRequest{file=" + Arrays.toString(this.file) + ", fileName=" + Objects.toString(this.fileName) + ", purpose=" + Objects.toString(this.purpose) + "}";
        }

        public static final class Builder {
            private byte[] file;
            private String fileName;
            private String purpose;

            public Builder file(byte[] file) {
                this.file = file;
                return this;
            }

            public Builder fileName(String fileName) {
                this.fileName = fileName;
                return this;
            }

            public Builder purpose(String purpose) {
                this.purpose = purpose;
                return this;
            }

            public Builder purpose(Purpose purpose) {
                this.purpose = purpose.getValue();
                return this;
            }

            public UploadFileRequest build() {
                Assert.notNull((Object)this.file, (String)"file must not be empty");
                Assert.notNull((Object)this.fileName, (String)"fileName must not be empty");
                Assert.notNull((Object)this.purpose, (String)"purpose must not be empty");
                return new UploadFileRequest(this.file, this.fileName, this.purpose);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record FileObject(@JsonProperty(value="id") String id, @JsonProperty(value="object") String object, @JsonProperty(value="bytes") Integer bytes, @JsonProperty(value="created_at") Integer createdAt, @JsonProperty(value="expires_at") Integer expiresAt, @JsonProperty(value="filename") String filename, @JsonProperty(value="purpose") String purpose) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ListFileRequest(@JsonProperty(value="after") String after, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="order") String order, @JsonProperty(value="purpose") String purpose) {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String after;
            private Integer limit;
            private String order;
            private String purpose;

            public Builder after(String after) {
                this.after = after;
                return this;
            }

            public Builder limit(Integer limit) {
                this.limit = limit;
                return this;
            }

            public Builder order(String order) {
                this.order = order;
                return this;
            }

            public Builder purpose(String purpose) {
                this.purpose = purpose;
                return this;
            }

            public Builder purpose(Purpose purpose) {
                this.purpose = purpose.getValue();
                return this;
            }

            public ListFileRequest build() {
                return new ListFileRequest(this.after, this.limit, this.order, this.purpose);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record FileObjectResponse(@JsonProperty(value="data") List<FileObject> data, @JsonProperty(value="object") String object) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DeleteFileResponse(@JsonProperty(value="id") String id, @JsonProperty(value="object") String object, @JsonProperty(value="deleted") Boolean deleted) {
    }

    public static enum Purpose {
        ASSISTANTS("assistants"),
        BATCH("batch"),
        FINE_TUNE("fine-tune"),
        VISION("vision"),
        USER_DATA("user_data"),
        EVALS("evals");

        private final String value;

        private Purpose(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

