/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.ai.embedding.EmbeddingOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OpenAiEmbeddingOptions
implements EmbeddingOptions {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="encoding_format")
    private String encodingFormat;
    @JsonProperty(value="dimensions")
    private Integer dimensions;
    @JsonProperty(value="user")
    private String user;

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getEncodingFormat() {
        return this.encodingFormat;
    }

    public void setEncodingFormat(String encodingFormat) {
        this.encodingFormat = encodingFormat;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public static class Builder {
        protected OpenAiEmbeddingOptions options = new OpenAiEmbeddingOptions();

        public Builder model(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder encodingFormat(String encodingFormat) {
            this.options.setEncodingFormat(encodingFormat);
            return this;
        }

        public Builder dimensions(Integer dimensions) {
            this.options.dimensions = dimensions;
            return this;
        }

        public Builder user(String user) {
            this.options.setUser(user);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withModel(String model) {
            this.options.setModel(model);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withEncodingFormat(String encodingFormat) {
            this.options.setEncodingFormat(encodingFormat);
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withDimensions(Integer dimensions) {
            this.options.dimensions = dimensions;
            return this;
        }

        @Deprecated(forRemoval=true, since="1.0.0-M5")
        public Builder withUser(String user) {
            this.options.setUser(user);
            return this;
        }

        public OpenAiEmbeddingOptions build() {
            return this.options;
        }
    }
}

