/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.embedding.observation.DefaultEmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationContext;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationDocumentation;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.openai.OpenAiEmbeddingOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.openai.api.common.OpenAiApiConstants;
import org.springframework.ai.openai.metadata.OpenAiUsage;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.lang.Nullable;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class OpenAiEmbeddingModel
extends AbstractEmbeddingModel {
    private static final Logger logger = LoggerFactory.getLogger(OpenAiEmbeddingModel.class);
    private static final EmbeddingModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultEmbeddingModelObservationConvention();
    private final OpenAiEmbeddingOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final OpenAiApi openAiApi;
    private final MetadataMode metadataMode;
    private final ObservationRegistry observationRegistry;
    private EmbeddingModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public OpenAiEmbeddingModel(OpenAiApi openAiApi) {
        this(openAiApi, MetadataMode.EMBED);
    }

    public OpenAiEmbeddingModel(OpenAiApi openAiApi, MetadataMode metadataMode) {
        this(openAiApi, metadataMode, OpenAiEmbeddingOptions.builder().withModel(OpenAiApi.DEFAULT_EMBEDDING_MODEL).build());
    }

    public OpenAiEmbeddingModel(OpenAiApi openAiApi, MetadataMode metadataMode, OpenAiEmbeddingOptions openAiEmbeddingOptions) {
        this(openAiApi, metadataMode, openAiEmbeddingOptions, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public OpenAiEmbeddingModel(OpenAiApi openAiApi, MetadataMode metadataMode, OpenAiEmbeddingOptions options, RetryTemplate retryTemplate) {
        this(openAiApi, metadataMode, options, retryTemplate, ObservationRegistry.NOOP);
    }

    public OpenAiEmbeddingModel(OpenAiApi openAiApi, MetadataMode metadataMode, OpenAiEmbeddingOptions options, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)openAiApi, (String)"openAiApi must not be null");
        Assert.notNull((Object)metadataMode, (String)"metadataMode must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry must not be null");
        this.openAiApi = openAiApi;
        this.metadataMode = metadataMode;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    public float[] embed(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        return this.embed(document.getFormattedContent(this.metadataMode));
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        OpenAiEmbeddingOptions requestOptions = this.mergeOptions(request.getOptions(), this.defaultOptions);
        OpenAiApi.EmbeddingRequest<List<String>> apiRequest = this.createRequest(request, requestOptions);
        EmbeddingModelObservationContext observationContext = EmbeddingModelObservationContext.builder().embeddingRequest(request).provider(OpenAiApiConstants.PROVIDER_NAME).requestOptions((EmbeddingOptions)requestOptions).build();
        return (EmbeddingResponse)EmbeddingModelObservationDocumentation.EMBEDDING_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            OpenAiApi.EmbeddingList apiEmbeddingResponse = (OpenAiApi.EmbeddingList)this.retryTemplate.execute(ctx -> (OpenAiApi.EmbeddingList)this.openAiApi.embeddings(apiRequest).getBody());
            if (apiEmbeddingResponse == null) {
                logger.warn("No embeddings returned for request: {}", (Object)request);
                return new EmbeddingResponse(List.of());
            }
            EmbeddingResponseMetadata metadata = new EmbeddingResponseMetadata(apiEmbeddingResponse.model(), (Usage)OpenAiUsage.from(apiEmbeddingResponse.usage()));
            List<Embedding> embeddings = apiEmbeddingResponse.data().stream().map(e -> new Embedding(e.embedding(), e.index())).toList();
            EmbeddingResponse embeddingResponse = new EmbeddingResponse(embeddings, metadata);
            observationContext.setResponse((Object)embeddingResponse);
            return embeddingResponse;
        });
    }

    private OpenAiApi.EmbeddingRequest<List<String>> createRequest(EmbeddingRequest request, OpenAiEmbeddingOptions requestOptions) {
        return new OpenAiApi.EmbeddingRequest<List<String>>(request.getInstructions(), requestOptions.getModel(), requestOptions.getEncodingFormat(), requestOptions.getDimensions(), requestOptions.getUser());
    }

    private OpenAiEmbeddingOptions mergeOptions(@Nullable EmbeddingOptions runtimeOptions, OpenAiEmbeddingOptions defaultOptions) {
        OpenAiEmbeddingOptions runtimeOptionsForProvider = (OpenAiEmbeddingOptions)ModelOptionsUtils.copyToTarget((Object)runtimeOptions, EmbeddingOptions.class, OpenAiEmbeddingOptions.class);
        if (runtimeOptionsForProvider == null) {
            return defaultOptions;
        }
        return OpenAiEmbeddingOptions.builder().withModel((String)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getModel(), (Object)defaultOptions.getModel())).withDimensions((Integer)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getDimensions(), (Object)defaultOptions.getDimensions())).withEncodingFormat((String)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getEncodingFormat(), (Object)defaultOptions.getEncodingFormat())).withUser((String)ModelOptionsUtils.mergeOption((Object)runtimeOptionsForProvider.getUser(), (Object)defaultOptions.getUser())).build();
    }

    public void setObservationConvention(EmbeddingModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }
}

