/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Consumer;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class OpenAiModerationApi {
    private static final String DEFAULT_BASE_URL = "https://api.openai.com";
    public static final String DEFAULT_MODERATION_MODEL = "text-moderation-latest";
    private final RestClient restClient;
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public OpenAiModerationApi(String openAiToken) {
        this(DEFAULT_BASE_URL, openAiToken, RestClient.builder(), RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public OpenAiModerationApi(String baseUrl, String openAiToken, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        Consumer<HttpHeaders> jsonContentHeaders = headers -> {
            headers.setBearerAuth(openAiToken);
            headers.setContentType(MediaType.APPLICATION_JSON);
        };
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(jsonContentHeaders).defaultStatusHandler(responseErrorHandler).build();
    }

    public ResponseEntity<OpenAiModerationResponse> createModeration(OpenAiModerationRequest openAiModerationRequest) {
        Assert.notNull((Object)openAiModerationRequest, (String)"Moderation request cannot be null.");
        Assert.hasLength((String)openAiModerationRequest.prompt(), (String)"Prompt cannot be empty.");
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("v1/moderations", new Object[0])).body((Object)openAiModerationRequest).retrieve().toEntity(OpenAiModerationResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OpenAiModerationRequest(@JsonProperty(value="input") String prompt, @JsonProperty(value="model") String model) {
        public OpenAiModerationRequest(String prompt) {
            this(prompt, null);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OpenAiModerationResponse(@JsonProperty(value="id") String id, @JsonProperty(value="model") String model, @JsonProperty(value="results") OpenAiModerationResult[] results) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Data(@JsonProperty(value="url") String url, @JsonProperty(value="b64_json") String b64Json, @JsonProperty(value="revised_prompt") String revisedPrompt) {
    }

    public record CategoryScores(@JsonProperty(value="sexual") double sexual, @JsonProperty(value="hate") double hate, @JsonProperty(value="harassment") double harassment, @JsonProperty(value="self-harm") double selfHarm, @JsonProperty(value="sexual/minors") double sexualMinors, @JsonProperty(value="hate/threatening") double hateThreatening, @JsonProperty(value="violence/graphic") double violenceGraphic, @JsonProperty(value="self-harm/intent") double selfHarmIntent, @JsonProperty(value="self-harm/instructions") double selfHarmInstructions, @JsonProperty(value="harassment/threatening") double harassmentThreatening, @JsonProperty(value="violence") double violence) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Categories(@JsonProperty(value="sexual") boolean sexual, @JsonProperty(value="hate") boolean hate, @JsonProperty(value="harassment") boolean harassment, @JsonProperty(value="self-harm") boolean selfHarm, @JsonProperty(value="sexual/minors") boolean sexualMinors, @JsonProperty(value="hate/threatening") boolean hateThreatening, @JsonProperty(value="violence/graphic") boolean violenceGraphic, @JsonProperty(value="self-harm/intent") boolean selfHarmIntent, @JsonProperty(value="self-harm/instructions") boolean selfHarmInstructions, @JsonProperty(value="harassment/threatening") boolean harassmentThreatening, @JsonProperty(value="violence") boolean violence) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record OpenAiModerationResult(@JsonProperty(value="flagged") boolean flagged, @JsonProperty(value="categories") Categories categories, @JsonProperty(value="category_scores") CategoryScores categoryScores) {
    }
}

