/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.ai.moderation.ModerationOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OpenAiModerationOptions
implements ModerationOptions {
    @JsonProperty(value="model")
    private String model = "text-moderation-latest";

    public static Builder builder() {
        return new Builder();
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public static class Builder {
        private final OpenAiModerationOptions options = new OpenAiModerationOptions();

        private Builder() {
        }

        public Builder withModel(String model) {
            this.options.setModel(model);
            return this;
        }

        public OpenAiModerationOptions build() {
            return this.options;
        }
    }
}

