/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.metadata.audio;

import java.util.HashMap;
import org.springframework.ai.chat.metadata.EmptyRateLimit;
import org.springframework.ai.chat.metadata.RateLimit;
import org.springframework.ai.model.ResponseMetadata;
import org.springframework.ai.openai.api.OpenAiAudioApi;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class OpenAiAudioSpeechResponseMetadata
extends HashMap<String, Object>
implements ResponseMetadata {
    protected static final String AI_METADATA_STRING = "{ @type: %1$s, requestsLimit: %2$s }";
    public static final OpenAiAudioSpeechResponseMetadata NULL = new OpenAiAudioSpeechResponseMetadata(){};
    @Nullable
    private RateLimit rateLimit;

    public static OpenAiAudioSpeechResponseMetadata from(OpenAiAudioApi.StructuredResponse result) {
        Assert.notNull((Object)result, (String)"OpenAI speech must not be null");
        OpenAiAudioSpeechResponseMetadata speechResponseMetadata = new OpenAiAudioSpeechResponseMetadata();
        return speechResponseMetadata;
    }

    public static OpenAiAudioSpeechResponseMetadata from(String result) {
        Assert.notNull((Object)result, (String)"OpenAI speech must not be null");
        OpenAiAudioSpeechResponseMetadata speechResponseMetadata = new OpenAiAudioSpeechResponseMetadata();
        return speechResponseMetadata;
    }

    public OpenAiAudioSpeechResponseMetadata() {
        this((RateLimit)null);
    }

    public OpenAiAudioSpeechResponseMetadata(@Nullable RateLimit rateLimit) {
        this.rateLimit = rateLimit;
    }

    @Nullable
    public RateLimit getRateLimit() {
        RateLimit rateLimit = this.rateLimit;
        return rateLimit != null ? rateLimit : new EmptyRateLimit();
    }

    public OpenAiAudioSpeechResponseMetadata withRateLimit(RateLimit rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    @Override
    public String toString() {
        return AI_METADATA_STRING.formatted(this.getClass().getName(), this.getRateLimit());
    }
}

