/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.audio.speech;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.ai.model.ModelResponse;
import org.springframework.ai.openai.audio.speech.Speech;
import org.springframework.ai.openai.metadata.audio.OpenAiAudioSpeechResponseMetadata;

public class SpeechResponse
implements ModelResponse<Speech> {
    private final Speech speech;
    private final OpenAiAudioSpeechResponseMetadata speechResponseMetadata;

    public SpeechResponse(Speech speech) {
        this(speech, OpenAiAudioSpeechResponseMetadata.NULL);
    }

    public SpeechResponse(Speech speech, OpenAiAudioSpeechResponseMetadata speechResponseMetadata) {
        this.speech = speech;
        this.speechResponseMetadata = speechResponseMetadata;
    }

    public Speech getResult() {
        return this.speech;
    }

    public List<Speech> getResults() {
        return Collections.singletonList(this.speech);
    }

    public OpenAiAudioSpeechResponseMetadata getMetadata() {
        return this.speechResponseMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpeechResponse)) {
            return false;
        }
        SpeechResponse that = (SpeechResponse)o;
        return Objects.equals(this.speech, that.speech) && Objects.equals(this.speechResponseMetadata, that.speechResponseMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.speech, this.speechResponseMetadata);
    }
}

