/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openaisdk;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.openai.client.OpenAIClient;
import com.openai.client.OpenAIClientAsync;
import com.openai.core.JsonValue;
import com.openai.models.FunctionDefinition;
import com.openai.models.FunctionParameters;
import com.openai.models.ReasoningEffort;
import com.openai.models.ResponseFormatJsonObject;
import com.openai.models.ResponseFormatJsonSchema;
import com.openai.models.ResponseFormatText;
import com.openai.models.chat.completions.ChatCompletion;
import com.openai.models.chat.completions.ChatCompletionAssistantMessageParam;
import com.openai.models.chat.completions.ChatCompletionAudio;
import com.openai.models.chat.completions.ChatCompletionAudioParam;
import com.openai.models.chat.completions.ChatCompletionChunk;
import com.openai.models.chat.completions.ChatCompletionContentPart;
import com.openai.models.chat.completions.ChatCompletionContentPartImage;
import com.openai.models.chat.completions.ChatCompletionContentPartInputAudio;
import com.openai.models.chat.completions.ChatCompletionContentPartText;
import com.openai.models.chat.completions.ChatCompletionCreateParams;
import com.openai.models.chat.completions.ChatCompletionFunctionTool;
import com.openai.models.chat.completions.ChatCompletionMessage;
import com.openai.models.chat.completions.ChatCompletionMessageFunctionToolCall;
import com.openai.models.chat.completions.ChatCompletionMessageParam;
import com.openai.models.chat.completions.ChatCompletionMessageToolCall;
import com.openai.models.chat.completions.ChatCompletionNamedToolChoice;
import com.openai.models.chat.completions.ChatCompletionStreamOptions;
import com.openai.models.chat.completions.ChatCompletionTool;
import com.openai.models.chat.completions.ChatCompletionToolChoiceOption;
import com.openai.models.chat.completions.ChatCompletionToolMessageParam;
import com.openai.models.chat.completions.ChatCompletionUserMessageParam;
import com.openai.models.completions.CompletionUsage;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.metadata.ChatResponseMetadata;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.chat.observation.ChatModelObservationDocumentation;
import org.springframework.ai.chat.observation.DefaultChatModelObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.content.Media;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.tool.DefaultToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingManager;
import org.springframework.ai.model.tool.ToolExecutionEligibilityPredicate;
import org.springframework.ai.model.tool.ToolExecutionResult;
import org.springframework.ai.model.tool.internal.ToolCallReactiveContextHolder;
import org.springframework.ai.observation.conventions.AiProvider;
import org.springframework.ai.openaisdk.OpenAiSdkChatOptions;
import org.springframework.ai.openaisdk.setup.OpenAiSdkSetup;
import org.springframework.ai.support.UsageCalculator;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.ContextView;

public class OpenAiSdkChatModel
implements ChatModel {
    private static final String DEFAULT_MODEL_NAME = OpenAiSdkChatOptions.DEFAULT_CHAT_MODEL;
    private static final ChatModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultChatModelObservationConvention();
    private static final ToolCallingManager DEFAULT_TOOL_CALLING_MANAGER = ToolCallingManager.builder().build();
    private final Logger logger = LoggerFactory.getLogger(OpenAiSdkChatModel.class);
    private final OpenAIClient openAiClient;
    private final OpenAIClientAsync openAiClientAsync;
    private final OpenAiSdkChatOptions options;
    private final ObservationRegistry observationRegistry;
    private final ToolCallingManager toolCallingManager;
    private final ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate;
    private ChatModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public OpenAiSdkChatModel() {
        this(null, null, null, null, null, null);
    }

    public OpenAiSdkChatModel(OpenAiSdkChatOptions options) {
        this(null, null, options, null, null, null);
    }

    public OpenAiSdkChatModel(OpenAiSdkChatOptions options, ObservationRegistry observationRegistry) {
        this(null, null, options, null, observationRegistry, null);
    }

    public OpenAiSdkChatModel(OpenAiSdkChatOptions options, ToolCallingManager toolCallingManager, ObservationRegistry observationRegistry) {
        this(null, null, options, toolCallingManager, observationRegistry, null);
    }

    public OpenAiSdkChatModel(OpenAIClient openAIClient, OpenAIClientAsync openAiClientAsync) {
        this(openAIClient, openAiClientAsync, null, null, null, null);
    }

    public OpenAiSdkChatModel(OpenAIClient openAIClient, OpenAIClientAsync openAiClientAsync, OpenAiSdkChatOptions options) {
        this(openAIClient, openAiClientAsync, options, null, null, null);
    }

    public OpenAiSdkChatModel(OpenAIClient openAIClient, OpenAIClientAsync openAiClientAsync, OpenAiSdkChatOptions options, ObservationRegistry observationRegistry) {
        this(openAIClient, openAiClientAsync, options, null, observationRegistry, null);
    }

    public OpenAiSdkChatModel(OpenAIClient openAiClient, OpenAIClientAsync openAiClientAsync, OpenAiSdkChatOptions options, ToolCallingManager toolCallingManager, ObservationRegistry observationRegistry, ToolExecutionEligibilityPredicate toolExecutionEligibilityPredicate) {
        this.options = options == null ? OpenAiSdkChatOptions.builder().model(DEFAULT_MODEL_NAME).build() : options;
        this.openAiClient = Objects.requireNonNullElseGet(openAiClient, () -> OpenAiSdkSetup.setupSyncClient(this.options.getBaseUrl(), this.options.getApiKey(), this.options.getCredential(), this.options.getMicrosoftDeploymentName(), this.options.getMicrosoftFoundryServiceVersion(), this.options.getOrganizationId(), this.options.isMicrosoftFoundry(), this.options.isGitHubModels(), this.options.getModel(), this.options.getTimeout(), this.options.getMaxRetries(), this.options.getProxy(), this.options.getCustomHeaders()));
        this.openAiClientAsync = Objects.requireNonNullElseGet(openAiClientAsync, () -> OpenAiSdkSetup.setupAsyncClient(this.options.getBaseUrl(), this.options.getApiKey(), this.options.getCredential(), this.options.getMicrosoftDeploymentName(), this.options.getMicrosoftFoundryServiceVersion(), this.options.getOrganizationId(), this.options.isMicrosoftFoundry(), this.options.isGitHubModels(), this.options.getModel(), this.options.getTimeout(), this.options.getMaxRetries(), this.options.getProxy(), this.options.getCustomHeaders()));
        this.observationRegistry = Objects.requireNonNullElse(observationRegistry, ObservationRegistry.NOOP);
        this.toolCallingManager = Objects.requireNonNullElse(toolCallingManager, DEFAULT_TOOL_CALLING_MANAGER);
        this.toolExecutionEligibilityPredicate = (ToolExecutionEligibilityPredicate)Objects.requireNonNullElse(toolExecutionEligibilityPredicate, new DefaultToolExecutionEligibilityPredicate());
    }

    public OpenAiSdkChatOptions getOptions() {
        return this.options;
    }

    public ChatResponse call(Prompt prompt) {
        if (this.openAiClient == null) {
            throw new IllegalStateException("OpenAI sync client is not configured. Have you set the 'streamUsage' option to false?");
        }
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalCall(requestPrompt, null);
    }

    public ChatResponse internalCall(Prompt prompt, ChatResponse previousChatResponse) {
        ChatCompletionCreateParams request = this.createRequest(prompt, false);
        ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(AiProvider.OPENAI_SDK.value()).build();
        ChatResponse response = (ChatResponse)ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            ChatCompletion chatCompletion = this.openAiClient.chat().completions().create(request);
            List choices = chatCompletion.choices();
            if (choices.isEmpty()) {
                this.logger.warn("No choices returned for prompt: {}", (Object)prompt);
                return new ChatResponse(List.of());
            }
            List<Generation> generations = choices.stream().map(choice -> {
                chatCompletion.id();
                choice.finishReason();
                Map<String, Object> metadata = Map.of("id", chatCompletion.id(), "role", choice.message()._role().asString().isPresent() ? choice.message()._role().asStringOrThrow() : "", "index", choice.index(), "finishReason", choice.finishReason().value().toString(), "refusal", choice.message().refusal().isPresent() ? choice.message().refusal() : "", "annotations", choice.message().annotations().isPresent() ? choice.message().annotations() : List.of(Map.of()));
                return this.buildGeneration((ChatCompletion.Choice)choice, metadata, request);
            }).toList();
            CompletionUsage usage = chatCompletion.usage().orElse(null);
            EmptyUsage currentChatResponseUsage = usage != null ? this.getDefaultUsage(usage) : new EmptyUsage();
            Usage accumulatedUsage = UsageCalculator.getCumulativeUsage((Usage)currentChatResponseUsage, (ChatResponse)previousChatResponse);
            ChatResponse chatResponse = new ChatResponse(generations, this.from(chatCompletion, accumulatedUsage));
            observationContext.setResponse((Object)chatResponse);
            return chatResponse;
        });
        if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), response)) {
            ToolExecutionResult toolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, response);
            if (toolExecutionResult.returnDirect()) {
                return ChatResponse.builder().from(response).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)toolExecutionResult)).build();
            }
            return this.internalCall(new Prompt(toolExecutionResult.conversationHistory(), prompt.getOptions()), response);
        }
        return response;
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        if (this.openAiClientAsync == null) {
            throw new IllegalStateException("OpenAI async client is not configured. Streaming is not supported with the current configuration. Have you set the 'streamUsage' option to true?");
        }
        Prompt requestPrompt = this.buildRequestPrompt(prompt);
        return this.internalStream(requestPrompt, null);
    }

    public AssistantMessage safeAssistantMessage(ChatResponse response) {
        if (response == null) {
            return null;
        }
        Generation gen = response.getResult();
        if (gen == null) {
            return null;
        }
        return gen.getOutput();
    }

    public Flux<ChatResponse> internalStream(Prompt prompt, ChatResponse previousChatResponse) {
        return Flux.deferContextual(contextView -> {
            ChatCompletionCreateParams request = this.createRequest(prompt, true);
            ConcurrentHashMap roleMap = new ConcurrentHashMap();
            ChatModelObservationContext observationContext = ChatModelObservationContext.builder().prompt(prompt).provider(AiProvider.OPENAI_SDK.value()).build();
            Observation observation = ChatModelObservationDocumentation.CHAT_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
            observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
            Flux chatResponses = Flux.create(sink -> this.openAiClientAsync.chat().completions().createStreaming(request).subscribe(chunk -> {
                try {
                    ChatCompletion chatCompletion = this.chunkToChatCompletion((ChatCompletionChunk)chunk);
                    String id = chatCompletion.id();
                    List<Generation> generations = chatCompletion.choices().stream().map(choice -> {
                        roleMap.putIfAbsent(id, choice.message()._role().asString().isPresent() ? choice.message()._role().asStringOrThrow() : "");
                        Map<String, Object> metadata = Map.of("id", id, "role", roleMap.getOrDefault(id, ""), "index", choice.index(), "finishReason", choice.finishReason().value(), "refusal", choice.message().refusal().isPresent() ? choice.message().refusal() : "", "annotations", choice.message().annotations().isPresent() ? choice.message().annotations() : List.of(), "chunkChoice", chunk.choices().get((int)choice.index()));
                        return this.buildGeneration((ChatCompletion.Choice)choice, metadata, request);
                    }).toList();
                    Optional usage = chatCompletion.usage();
                    CompletionUsage usageVal = usage.orElse(null);
                    EmptyUsage currentUsage = usageVal != null ? this.getDefaultUsage(usageVal) : new EmptyUsage();
                    Usage accumulated = UsageCalculator.getCumulativeUsage((Usage)currentUsage, (ChatResponse)previousChatResponse);
                    sink.next((Object)new ChatResponse(generations, this.from(chatCompletion, accumulated)));
                }
                catch (Exception e) {
                    this.logger.error("Error processing chat completion", (Throwable)e);
                    sink.error((Throwable)e);
                }
            }).onCompleteFuture().whenComplete((unused, throwable) -> {
                if (throwable != null) {
                    sink.error(throwable);
                } else {
                    sink.complete();
                }
            })).buffer(2, 1).map(buffer -> {
                Usage usage;
                ChatResponse second;
                ChatResponse first = (ChatResponse)buffer.get(0);
                if (request.streamOptions().isPresent() && buffer.size() == 2 && (second = (ChatResponse)buffer.get(1)) != null && !UsageCalculator.isEmpty((Usage)(usage = second.getMetadata().getUsage()))) {
                    return new ChatResponse(first.getResults(), this.from(first.getMetadata(), usage));
                }
                return first;
            });
            Flux flux = chatResponses.contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            return flux.collectList().flatMapMany(list -> {
                if (list.isEmpty()) {
                    return Flux.empty();
                }
                boolean hasToolCalls = list.stream().map(this::safeAssistantMessage).filter(Objects::nonNull).anyMatch(am -> !CollectionUtils.isEmpty((Collection)am.getToolCalls()));
                if (!hasToolCalls) {
                    if (list.size() > 2) {
                        ChatResponse penultimateResponse = (ChatResponse)list.get(list.size() - 2);
                        ChatResponse lastResponse = (ChatResponse)list.get(list.size() - 1);
                        Usage usage = lastResponse.getMetadata().getUsage();
                        observationContext.setResponse((Object)new ChatResponse(penultimateResponse.getResults(), this.from(penultimateResponse.getMetadata(), usage)));
                    }
                    return Flux.fromIterable((Iterable)list);
                }
                HashMap<String, ToolCallBuilder> builders = new HashMap<String, ToolCallBuilder>();
                StringBuilder text = new StringBuilder();
                ChatResponseMetadata finalMetadata = null;
                ChatGenerationMetadata finalGenMetadata = null;
                HashMap props = new HashMap();
                for (ChatResponse chatResponse : list) {
                    Generation generation;
                    AssistantMessage am2 = this.safeAssistantMessage(chatResponse);
                    if (am2 == null) continue;
                    if (am2.getText() != null) {
                        text.append(am2.getText());
                    }
                    if (am2.getMetadata() != null) {
                        props.putAll(am2.getMetadata());
                    }
                    if (!CollectionUtils.isEmpty((Collection)am2.getToolCalls())) {
                        ChatCompletionChunk.Choice chunkChoice;
                        Object ccObj = am2.getMetadata().get("chunkChoice");
                        if (ccObj instanceof ChatCompletionChunk.Choice && (chunkChoice = (ChatCompletionChunk.Choice)ccObj).delta().toolCalls().isPresent()) {
                            List deltaCalls = (List)chunkChoice.delta().toolCalls().get();
                            for (int i = 0; i < am2.getToolCalls().size() && i < deltaCalls.size(); ++i) {
                                AssistantMessage.ToolCall tc2 = (AssistantMessage.ToolCall)am2.getToolCalls().get(i);
                                ChatCompletionChunk.Choice.Delta.ToolCall dtc = (ChatCompletionChunk.Choice.Delta.ToolCall)deltaCalls.get(i);
                                String key = chunkChoice.index() + "-" + dtc.index();
                                ToolCallBuilder toolCallBuilder = builders.computeIfAbsent(key, k -> new ToolCallBuilder());
                                toolCallBuilder.merge(tc2);
                            }
                        } else {
                            for (AssistantMessage.ToolCall tc3 : am2.getToolCalls()) {
                                ToolCallBuilder toolCallBuilder = builders.computeIfAbsent(tc3.id(), k -> new ToolCallBuilder());
                                toolCallBuilder.merge(tc3);
                            }
                        }
                    }
                    if ((generation = chatResponse.getResult()) != null && generation.getMetadata() != null && generation.getMetadata() != ChatGenerationMetadata.NULL) {
                        finalGenMetadata = generation.getMetadata();
                    }
                    if (chatResponse.getMetadata() == null) continue;
                    finalMetadata = chatResponse.getMetadata();
                }
                List<AssistantMessage.ToolCall> merged = builders.values().stream().map(ToolCallBuilder::build).filter(tc -> StringUtils.hasText((String)tc.name())).toList();
                AssistantMessage.Builder assistantMessageBuilder = AssistantMessage.builder().content(text.toString()).properties(props);
                if (!merged.isEmpty()) {
                    assistantMessageBuilder.toolCalls(merged);
                }
                AssistantMessage assistantMessage = assistantMessageBuilder.build();
                Generation finalGen = new Generation(assistantMessage, finalGenMetadata != null ? finalGenMetadata : ChatGenerationMetadata.NULL);
                ChatResponse aggregated = new ChatResponse(List.of(finalGen), finalMetadata);
                observationContext.setResponse((Object)aggregated);
                if (this.toolExecutionEligibilityPredicate.isToolExecutionRequired(prompt.getOptions(), aggregated)) {
                    return Flux.deferContextual(ctx -> {
                        ToolExecutionResult tetoolExecutionResult;
                        try {
                            ToolCallReactiveContextHolder.setContext((ContextView)ctx);
                            tetoolExecutionResult = this.toolCallingManager.executeToolCalls(prompt, aggregated);
                        }
                        finally {
                            ToolCallReactiveContextHolder.clearContext();
                        }
                        if (tetoolExecutionResult.returnDirect()) {
                            return Flux.just((Object)ChatResponse.builder().from(aggregated).generations(ToolExecutionResult.buildGenerations((ToolExecutionResult)tetoolExecutionResult)).build());
                        }
                        return this.internalStream(new Prompt(tetoolExecutionResult.conversationHistory(), prompt.getOptions()), aggregated);
                    }).subscribeOn(Schedulers.boundedElastic());
                }
                return Flux.just((Object)aggregated);
            }).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop());
        });
    }

    private Generation buildGeneration(ChatCompletion.Choice choice, Map<String, Object> metadata, ChatCompletionCreateParams request) {
        ChatCompletionMessage message = choice.message();
        List<Object> toolCalls = new ArrayList();
        if (metadata.containsKey("chunkChoice")) {
            ChatCompletionChunk.Choice chunkChoice;
            Object chunkChoiceObj = metadata.get("chunkChoice");
            if (chunkChoiceObj instanceof ChatCompletionChunk.Choice && (chunkChoice = (ChatCompletionChunk.Choice)chunkChoiceObj).delta().toolCalls().isPresent()) {
                toolCalls = ((List)chunkChoice.delta().toolCalls().get()).stream().filter(tc -> tc.function().isPresent()).map(tc -> {
                    Optional funcOpt = tc.function();
                    if (funcOpt.isEmpty()) {
                        return null;
                    }
                    ChatCompletionChunk.Choice.Delta.ToolCall.Function func = (ChatCompletionChunk.Choice.Delta.ToolCall.Function)funcOpt.get();
                    String id = tc.id().orElse("");
                    String name = func.name().orElse("");
                    String arguments = func.arguments().orElse("");
                    return new AssistantMessage.ToolCall(id, "function", name, arguments);
                }).filter(Objects::nonNull).toList();
            }
        } else {
            toolCalls = message.toolCalls().map(list -> list.stream().filter(tc -> tc.function().isPresent()).map(tc -> {
                Optional opt = tc.function();
                if (opt.isEmpty()) {
                    return null;
                }
                ChatCompletionMessageFunctionToolCall funcCall = (ChatCompletionMessageFunctionToolCall)opt.get();
                ChatCompletionMessageFunctionToolCall.Function functionDef = funcCall.function();
                String id = funcCall.id();
                String name = functionDef.name();
                String arguments = functionDef.arguments();
                return new AssistantMessage.ToolCall(id, "function", name, arguments);
            }).filter(Objects::nonNull).toList()).orElse(List.of());
        }
        ChatGenerationMetadata.Builder generationMetadataBuilder = ChatGenerationMetadata.builder().finishReason(choice.finishReason().value().name());
        String textContent = message.content().orElse("");
        ArrayList<Media> media = new ArrayList<Media>();
        if (message.audio().isPresent() && StringUtils.hasText((String)((ChatCompletionAudio)message.audio().get()).data()) && request.audio().isPresent()) {
            ChatCompletionAudio audioOutput = (ChatCompletionAudio)message.audio().get();
            String mimeType = String.format("audio/%s", ((ChatCompletionAudioParam)request.audio().get()).format().value().name().toLowerCase());
            byte[] audioData = Base64.getDecoder().decode(audioOutput.data());
            ByteArrayResource resource = new ByteArrayResource(audioData);
            Media.builder().mimeType(MimeTypeUtils.parseMimeType((String)mimeType)).data((Resource)resource).id(audioOutput.id()).build();
            media.add(Media.builder().mimeType(MimeTypeUtils.parseMimeType((String)mimeType)).data((Resource)resource).id(audioOutput.id()).build());
            if (!StringUtils.hasText((String)textContent)) {
                textContent = audioOutput.transcript();
            }
            generationMetadataBuilder.metadata("audioId", (Object)audioOutput.id());
            generationMetadataBuilder.metadata("audioExpiresAt", (Object)audioOutput.expiresAt());
        }
        AssistantMessage assistantMessage = AssistantMessage.builder().content(textContent).properties(metadata).toolCalls(toolCalls).media(media).build();
        return new Generation(assistantMessage, generationMetadataBuilder.build());
    }

    private ChatResponseMetadata from(ChatCompletion result, Usage usage) {
        Assert.notNull((Object)result, (String)"OpenAI ChatCompletion must not be null");
        result.model();
        result.id();
        return ChatResponseMetadata.builder().id(result.id()).usage(usage).model(result.model()).keyValue("created", (Object)result.created()).build();
    }

    private ChatResponseMetadata from(ChatResponseMetadata chatResponseMetadata, Usage usage) {
        Assert.notNull((Object)chatResponseMetadata, (String)"OpenAI ChatResponseMetadata must not be null");
        return ChatResponseMetadata.builder().id(chatResponseMetadata.getId() != null ? chatResponseMetadata.getId() : "").usage(usage).model(chatResponseMetadata.getModel() != null ? chatResponseMetadata.getModel() : "").build();
    }

    private ChatCompletion chunkToChatCompletion(ChatCompletionChunk chunk) {
        List choices = chunk._choices().isMissing() ? List.of() : chunk.choices().stream().map(chunkChoice -> {
            ChatCompletion.Choice.FinishReason finishReason = ChatCompletion.Choice.FinishReason.of((String)"");
            if (chunkChoice.finishReason().isPresent()) {
                finishReason = ChatCompletion.Choice.FinishReason.of((String)((ChatCompletionChunk.Choice.FinishReason)chunkChoice.finishReason().get()).value().name().toLowerCase());
            }
            ChatCompletion.Choice.Builder choiceBuilder = ChatCompletion.Choice.builder().finishReason(finishReason).index(chunkChoice.index()).message(ChatCompletionMessage.builder().content(chunkChoice.delta().content()).refusal(chunkChoice.delta().refusal()).build());
            if (chunkChoice.logprobs().isPresent()) {
                ChatCompletionChunk.Choice.Logprobs logprobs = (ChatCompletionChunk.Choice.Logprobs)chunkChoice.logprobs().get();
                choiceBuilder.logprobs(ChatCompletion.Choice.Logprobs.builder().content(logprobs.content()).refusal(logprobs.refusal()).build());
            } else {
                choiceBuilder.logprobs(ChatCompletion.Choice.Logprobs.builder().content(List.of()).refusal(List.of()).build());
            }
            chunkChoice.delta();
            return choiceBuilder.build();
        }).toList();
        return ChatCompletion.builder().id(chunk.id()).choices(choices).created(chunk.created()).model(chunk.model()).usage(chunk.usage().orElse(CompletionUsage.builder().promptTokens(0L).completionTokens(0L).totalTokens(0L).build())).build();
    }

    private DefaultUsage getDefaultUsage(CompletionUsage usage) {
        return new DefaultUsage(Integer.valueOf(Math.toIntExact(usage.promptTokens())), Integer.valueOf(Math.toIntExact(usage.completionTokens())), Integer.valueOf(Math.toIntExact(usage.totalTokens())), (Object)usage);
    }

    Prompt buildRequestPrompt(Prompt prompt) {
        OpenAiSdkChatOptions runtimeOptions = null;
        if (prompt.getOptions() != null) {
            ChatOptions chatOptions = prompt.getOptions();
            if (chatOptions instanceof ToolCallingChatOptions) {
                ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)chatOptions;
                runtimeOptions = (OpenAiSdkChatOptions)ModelOptionsUtils.copyToTarget((Object)toolCallingChatOptions, ToolCallingChatOptions.class, OpenAiSdkChatOptions.class);
            } else {
                runtimeOptions = (OpenAiSdkChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, OpenAiSdkChatOptions.class);
            }
        }
        OpenAiSdkChatOptions requestOptions = OpenAiSdkChatOptions.builder().from(this.options).merge(runtimeOptions != null ? runtimeOptions : OpenAiSdkChatOptions.builder().build()).build();
        if (runtimeOptions != null) {
            if (runtimeOptions.getTopK() != null) {
                this.logger.warn("The topK option is not supported by OpenAI chat models. Ignoring.");
            }
            requestOptions.setInternalToolExecutionEnabled(runtimeOptions.getInternalToolExecutionEnabled() != null ? runtimeOptions.getInternalToolExecutionEnabled() : this.options.getInternalToolExecutionEnabled());
            requestOptions.setToolNames(ToolCallingChatOptions.mergeToolNames(runtimeOptions.getToolNames(), this.options.getToolNames()));
            requestOptions.setToolCallbacks(ToolCallingChatOptions.mergeToolCallbacks(runtimeOptions.getToolCallbacks(), this.options.getToolCallbacks()));
            requestOptions.setToolContext(ToolCallingChatOptions.mergeToolContext(runtimeOptions.getToolContext(), this.options.getToolContext()));
        } else {
            requestOptions.setInternalToolExecutionEnabled(this.options.getInternalToolExecutionEnabled());
            requestOptions.setToolNames(this.options.getToolNames());
            requestOptions.setToolCallbacks(this.options.getToolCallbacks());
            requestOptions.setToolContext(this.options.getToolContext());
        }
        ToolCallingChatOptions.validateToolCallbacks(requestOptions.getToolCallbacks());
        return new Prompt(prompt.getInstructions(), (ChatOptions)requestOptions);
    }

    ChatCompletionCreateParams createRequest(Prompt prompt, boolean stream) {
        List toolDefinitions;
        Object jsonSchemaBuilder;
        List chatCompletionMessageParams = prompt.getInstructions().stream().map(message -> {
            if (message.getMessageType() == MessageType.USER || message.getMessageType() == MessageType.SYSTEM) {
                UserMessage userMessage;
                ChatCompletionUserMessageParam.Builder builder = ChatCompletionUserMessageParam.builder();
                if (message instanceof UserMessage && !CollectionUtils.isEmpty((Collection)(userMessage = (UserMessage)message).getMedia())) {
                    ArrayList<ChatCompletionContentPart> parts = new ArrayList<ChatCompletionContentPart>();
                    if (!message.getText().isEmpty()) {
                        parts.add(ChatCompletionContentPart.ofText((ChatCompletionContentPartText)ChatCompletionContentPartText.builder().text(message.getText()).build()));
                    }
                    userMessage.getMedia().forEach(media -> {
                        String mimeType = media.getMimeType().toString();
                        if (mimeType.startsWith("image/")) {
                            Object patt0$temp = media.getData();
                            if (patt0$temp instanceof URI) {
                                URI uri = (URI)patt0$temp;
                                parts.add(ChatCompletionContentPart.ofImageUrl((ChatCompletionContentPartImage)ChatCompletionContentPartImage.builder().imageUrl(ChatCompletionContentPartImage.ImageUrl.builder().url(uri.toString()).build()).build()));
                            } else {
                                Object patt1$temp = media.getData();
                                if (patt1$temp instanceof String) {
                                    String text = (String)patt1$temp;
                                    parts.add(ChatCompletionContentPart.ofImageUrl((ChatCompletionContentPartImage)ChatCompletionContentPartImage.builder().imageUrl(ChatCompletionContentPartImage.ImageUrl.builder().url(text).build()).build()));
                                } else {
                                    Object patt2$temp = media.getData();
                                    if (patt2$temp instanceof byte[]) {
                                        byte[] bytes = (byte[])patt2$temp;
                                        ChatCompletionContentPartImage.ImageUrl.Builder imageUrlBuilder = ChatCompletionContentPartImage.ImageUrl.builder();
                                        imageUrlBuilder.url("data:" + mimeType + ";base64," + Base64.getEncoder().encodeToString(bytes));
                                        parts.add(ChatCompletionContentPart.ofImageUrl((ChatCompletionContentPartImage)ChatCompletionContentPartImage.builder().imageUrl(imageUrlBuilder.build()).build()));
                                    } else {
                                        this.logger.info("Could not process image media with data of type: {}. Only java.net.URI is supported for image URLs.", (Object)media.getData().getClass().getSimpleName());
                                    }
                                }
                            }
                        } else if (mimeType.startsWith("audio/")) {
                            parts.add(ChatCompletionContentPart.ofInputAudio((ChatCompletionContentPartInputAudio)ChatCompletionContentPartInputAudio.builder().inputAudio(ChatCompletionContentPartInputAudio.builder().inputAudio(ChatCompletionContentPartInputAudio.InputAudio.builder().data(this.fromAudioData(media.getData())).format(mimeType.contains("mp3") ? ChatCompletionContentPartInputAudio.InputAudio.Format.MP3 : ChatCompletionContentPartInputAudio.InputAudio.Format.WAV).build()).build().inputAudio()).build()));
                        } else {
                            parts.add(ChatCompletionContentPart.ofText((ChatCompletionContentPartText)ChatCompletionContentPartText.builder().text(this.fromMediaData(media.getMimeType(), media.getData())).build()));
                        }
                    });
                    builder.contentOfArrayOfContentParts(parts);
                } else {
                    builder.content(ChatCompletionContentPartText.builder().text(message.getText()).build().text());
                }
                if (message.getMessageType() == MessageType.USER) {
                    builder.role(JsonValue.from((Object)MessageType.USER.getValue()));
                } else {
                    builder.role(JsonValue.from((Object)MessageType.SYSTEM.getValue()));
                }
                return List.of(ChatCompletionMessageParam.ofUser((ChatCompletionUserMessageParam)builder.build()));
            }
            if (message.getMessageType() == MessageType.ASSISTANT) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                ChatCompletionAssistantMessageParam.Builder builder = ChatCompletionAssistantMessageParam.builder().role(JsonValue.from((Object)MessageType.ASSISTANT.getValue()));
                if (assistantMessage.getText() != null) {
                    builder.content(ChatCompletionAssistantMessageParam.builder().content(assistantMessage.getText()).build().content());
                }
                if (!CollectionUtils.isEmpty((Collection)assistantMessage.getToolCalls())) {
                    List<ChatCompletionMessageToolCall> toolCalls = assistantMessage.getToolCalls().stream().map(toolCall -> ChatCompletionMessageToolCall.ofFunction((ChatCompletionMessageFunctionToolCall)ChatCompletionMessageFunctionToolCall.builder().id(toolCall.id()).function(ChatCompletionMessageFunctionToolCall.Function.builder().name(toolCall.name()).arguments(toolCall.arguments()).build()).build())).toList();
                    builder.toolCalls(toolCalls);
                }
                return List.of(ChatCompletionMessageParam.ofAssistant((ChatCompletionAssistantMessageParam)builder.build()));
            }
            if (message.getMessageType() == MessageType.TOOL) {
                ToolResponseMessage toolMessage = (ToolResponseMessage)message;
                ChatCompletionToolMessageParam.Builder builder = ChatCompletionToolMessageParam.builder();
                builder.content(toolMessage.getText() != null ? toolMessage.getText() : "");
                builder.role(JsonValue.from((Object)MessageType.TOOL.getValue()));
                if (toolMessage.getResponses().isEmpty()) {
                    return List.of(ChatCompletionMessageParam.ofTool((ChatCompletionToolMessageParam)builder.build()));
                }
                return toolMessage.getResponses().stream().map(response -> {
                    String callId = response.id();
                    String callResponse = response.responseData();
                    return ChatCompletionMessageParam.ofTool((ChatCompletionToolMessageParam)builder.toolCallId(callId).content(callResponse).build());
                }).toList();
            }
            throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message.getMessageType()));
        }).flatMap(Collection::stream).toList();
        ChatCompletionCreateParams.Builder builder = ChatCompletionCreateParams.builder();
        chatCompletionMessageParams.forEach(arg_0 -> ((ChatCompletionCreateParams.Builder)builder).addMessage(arg_0));
        OpenAiSdkChatOptions requestOptions = (OpenAiSdkChatOptions)prompt.getOptions();
        if (requestOptions.getDeploymentName() != null) {
            builder.model(requestOptions.getDeploymentName());
        } else if (requestOptions.getModel() != null) {
            builder.model(requestOptions.getModel());
        }
        if (requestOptions.getFrequencyPenalty() != null) {
            builder.frequencyPenalty(requestOptions.getFrequencyPenalty());
        }
        if (requestOptions.getLogitBias() != null) {
            builder.logitBias(ChatCompletionCreateParams.LogitBias.builder().putAllAdditionalProperties(requestOptions.getLogitBias().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonValue.from(entry.getValue())))).build());
        }
        if (requestOptions.getLogprobs() != null) {
            builder.logprobs(requestOptions.getLogprobs());
        }
        if (requestOptions.getTopLogprobs() != null) {
            builder.topLogprobs((long)requestOptions.getTopLogprobs().intValue());
        }
        if (requestOptions.getMaxTokens() != null) {
            builder.maxTokens((long)requestOptions.getMaxTokens().intValue());
        }
        if (requestOptions.getMaxCompletionTokens() != null) {
            builder.maxCompletionTokens((long)requestOptions.getMaxCompletionTokens().intValue());
        }
        if (requestOptions.getN() != null) {
            builder.n((long)requestOptions.getN().intValue());
        }
        if (requestOptions.getOutputModalities() != null) {
            builder.modalities(requestOptions.getOutputModalities().stream().map(modality -> ChatCompletionCreateParams.Modality.of((String)modality.toLowerCase())).toList());
        }
        if (requestOptions.getOutputAudio() != null) {
            builder.audio(requestOptions.getOutputAudio().toChatCompletionAudioParam());
        }
        if (requestOptions.getPresencePenalty() != null) {
            builder.presencePenalty(requestOptions.getPresencePenalty());
        }
        if (requestOptions.getResponseFormat() != null) {
            ResponseFormat responseFormat = requestOptions.getResponseFormat();
            if (responseFormat.getType().equals((Object)ResponseFormat.Type.TEXT)) {
                builder.responseFormat(ResponseFormatText.builder().build());
            } else if (responseFormat.getType().equals((Object)ResponseFormat.Type.JSON_OBJECT)) {
                builder.responseFormat(ResponseFormatJsonObject.builder().build());
            } else if (responseFormat.getType().equals((Object)ResponseFormat.Type.JSON_SCHEMA)) {
                String jsonSchemaString = responseFormat.getJsonSchema() != null ? responseFormat.getJsonSchema() : "";
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    jsonSchemaBuilder = ResponseFormatJsonSchema.JsonSchema.builder();
                    jsonSchemaBuilder.name("json_schema");
                    jsonSchemaBuilder.strict(true);
                    ResponseFormatJsonSchema.JsonSchema.Schema schema = (ResponseFormatJsonSchema.JsonSchema.Schema)mapper.readValue(jsonSchemaString, ResponseFormatJsonSchema.JsonSchema.Schema.class);
                    jsonSchemaBuilder.schema(schema);
                    builder.responseFormat(ResponseFormatJsonSchema.builder().jsonSchema(jsonSchemaBuilder.build()).build());
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException("Failed to parse JSON schema: " + jsonSchemaString, e2);
                }
            } else {
                throw new IllegalArgumentException("Unsupported response format type: " + String.valueOf((Object)responseFormat.getType()));
            }
        }
        if (requestOptions.getSeed() != null) {
            builder.seed((long)requestOptions.getSeed().intValue());
        }
        if (requestOptions.getStop() != null && !requestOptions.getStop().isEmpty()) {
            if (requestOptions.getStop().size() == 1) {
                builder.stop(ChatCompletionCreateParams.Stop.ofString((String)requestOptions.getStop().get(0)));
            } else {
                builder.stop(ChatCompletionCreateParams.Stop.ofStrings(requestOptions.getStop()));
            }
        }
        if (requestOptions.getTemperature() != null) {
            builder.temperature(requestOptions.getTemperature());
        }
        if (requestOptions.getTopP() != null) {
            builder.topP(requestOptions.getTopP());
        }
        if (requestOptions.getUser() != null) {
            builder.user(requestOptions.getUser());
        }
        if (requestOptions.getParallelToolCalls() != null) {
            builder.parallelToolCalls(requestOptions.getParallelToolCalls().booleanValue());
        }
        if (requestOptions.getReasoningEffort() != null) {
            builder.reasoningEffort(ReasoningEffort.of((String)requestOptions.getReasoningEffort().toLowerCase()));
        }
        if (requestOptions.getVerbosity() != null) {
            builder.verbosity(ChatCompletionCreateParams.Verbosity.of((String)requestOptions.getVerbosity()));
        }
        if (requestOptions.getStore() != null) {
            builder.store(requestOptions.getStore());
        }
        if (requestOptions.getMetadata() != null && !requestOptions.getMetadata().isEmpty()) {
            builder.metadata(ChatCompletionCreateParams.Metadata.builder().putAllAdditionalProperties(requestOptions.getMetadata().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonValue.from(entry.getValue())))).build());
        }
        if (requestOptions.getServiceTier() != null) {
            builder.serviceTier(ChatCompletionCreateParams.ServiceTier.of((String)requestOptions.getServiceTier()));
        }
        if (stream) {
            if (requestOptions.getStreamOptions() != null) {
                ChatCompletionStreamOptions.Builder streamOptionsBuilder = ChatCompletionStreamOptions.builder();
                OpenAiSdkChatOptions.StreamOptions ops = requestOptions.getStreamOptions();
                streamOptionsBuilder.includeObfuscation(ops.includeObfuscation() != null && ops.includeObfuscation() != false);
                streamOptionsBuilder.includeUsage(ops.includeUsage() != null && ops.includeUsage() != false);
                if (!CollectionUtils.isEmpty(ops.additionalProperties())) {
                    Map nativeParams = ops.additionalProperties().entrySet().stream().map(e -> Map.entry((String)e.getKey(), JsonValue.from(e.getValue()))).collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), (JsonValue)e.getValue()), HashMap::putAll);
                    streamOptionsBuilder.putAllAdditionalProperties(nativeParams);
                }
                builder.streamOptions(streamOptionsBuilder.build());
            } else {
                builder.streamOptions(ChatCompletionStreamOptions.builder().includeUsage(true).build());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(toolDefinitions = this.toolCallingManager.resolveToolDefinitions((ToolCallingChatOptions)requestOptions)))) {
            builder.tools(this.getChatCompletionTools(toolDefinitions));
        }
        if (requestOptions.getToolChoice() != null) {
            jsonSchemaBuilder = requestOptions.getToolChoice();
            if (jsonSchemaBuilder instanceof ChatCompletionToolChoiceOption) {
                ChatCompletionToolChoiceOption toolChoiceOption = (ChatCompletionToolChoiceOption)jsonSchemaBuilder;
                builder.toolChoice(toolChoiceOption);
            } else {
                jsonSchemaBuilder = requestOptions.getToolChoice();
                if (jsonSchemaBuilder instanceof String) {
                    String json = (String)jsonSchemaBuilder;
                    try {
                        JsonNode node = ModelOptionsUtils.OBJECT_MAPPER.readTree(json);
                        builder.toolChoice(OpenAiSdkChatModel.parseToolChoice(node));
                    }
                    catch (Exception e3) {
                        throw new IllegalArgumentException("Failed to parse toolChoice JSON: " + json, e3);
                    }
                }
            }
        }
        return builder.build();
    }

    public static ChatCompletionToolChoiceOption parseToolChoice(JsonNode node) {
        String type;
        switch (type = node.get("type").asText()) {
            case "function": {
                String functionName = node.get("function").get("name").asText();
                ChatCompletionNamedToolChoice.Function func = ChatCompletionNamedToolChoice.Function.builder().name(functionName).build();
                ChatCompletionNamedToolChoice named = ChatCompletionNamedToolChoice.builder().function(func).build();
                return ChatCompletionToolChoiceOption.ofNamedToolChoice((ChatCompletionNamedToolChoice)named);
            }
            case "auto": {
                return ChatCompletionToolChoiceOption.ofAuto((ChatCompletionToolChoiceOption.Auto)ChatCompletionToolChoiceOption.Auto.AUTO);
            }
            case "required": {
                throw new UnsupportedOperationException("SDK version does not support typed 'required' toolChoice");
            }
            case "none": {
                throw new UnsupportedOperationException("SDK version does not support typed 'none' toolChoice");
            }
        }
        throw new IllegalArgumentException("Unknown tool_choice type: " + type);
    }

    private String fromAudioData(Object audioData) {
        if (audioData instanceof byte[]) {
            byte[] bytes = (byte[])audioData;
            return Base64.getEncoder().encodeToString(bytes);
        }
        throw new IllegalArgumentException("Unsupported audio data type: " + audioData.getClass().getSimpleName());
    }

    private String fromMediaData(MimeType mimeType, Object mediaContentData) {
        if (mediaContentData instanceof byte[]) {
            byte[] bytes = (byte[])mediaContentData;
            return String.format("data:%s;base64,%s", mimeType.toString(), Base64.getEncoder().encodeToString(bytes));
        }
        if (mediaContentData instanceof String) {
            String text = (String)mediaContentData;
            return text;
        }
        throw new IllegalArgumentException("Unsupported media data type: " + mediaContentData.getClass().getSimpleName());
    }

    private List<ChatCompletionTool> getChatCompletionTools(List<ToolDefinition> toolDefinitions) {
        return toolDefinitions.stream().map(toolDefinition -> {
            FunctionParameters.Builder parametersBuilder = FunctionParameters.builder();
            if (!toolDefinition.inputSchema().isEmpty()) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    Map schemaMap = (Map)mapper.readValue(toolDefinition.inputSchema(), Map.class);
                    schemaMap.forEach((key, value) -> parametersBuilder.putAdditionalProperty(key, JsonValue.from((Object)value)));
                    parametersBuilder.putAdditionalProperty("strict", JsonValue.from((Object)true));
                }
                catch (Exception e) {
                    this.logger.error("Failed to parse tool schema", (Throwable)e);
                }
            }
            FunctionDefinition functionDefinition = FunctionDefinition.builder().name(toolDefinition.name()).description(toolDefinition.description()).parameters(parametersBuilder.build()).build();
            return ChatCompletionTool.ofFunction((ChatCompletionFunctionTool)ChatCompletionFunctionTool.builder().function(functionDefinition).build());
        }).toList();
    }

    public ChatOptions getDefaultOptions() {
        return this.options.copy();
    }

    public void setObservationConvention(ChatModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }

    public static class ResponseFormat {
        private Type type = Type.TEXT;
        private String jsonSchema;

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public String getJsonSchema() {
            return this.jsonSchema;
        }

        public void setJsonSchema(String jsonSchema) {
            this.jsonSchema = jsonSchema;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static enum Type {
            TEXT,
            JSON_OBJECT,
            JSON_SCHEMA;

        }

        public static final class Builder {
            private final ResponseFormat responseFormat = new ResponseFormat();

            private Builder() {
            }

            public Builder type(Type type) {
                this.responseFormat.setType(type);
                return this;
            }

            public Builder jsonSchema(String jsonSchema) {
                this.responseFormat.setType(Type.JSON_SCHEMA);
                this.responseFormat.setJsonSchema(jsonSchema);
                return this;
            }

            public ResponseFormat build() {
                return this.responseFormat;
            }
        }
    }

    private static class ToolCallBuilder {
        private String id = "";
        private String type = "function";
        private String name = "";
        private StringBuilder arguments = new StringBuilder();

        private ToolCallBuilder() {
        }

        void merge(AssistantMessage.ToolCall toolCall) {
            if (toolCall.id() != null && !toolCall.id().isEmpty()) {
                this.id = toolCall.id();
            }
            if (toolCall.type() != null && !toolCall.type().isEmpty()) {
                this.type = toolCall.type();
            }
            if (toolCall.name() != null && !toolCall.name().isEmpty()) {
                this.name = toolCall.name();
            }
            if (toolCall.arguments() != null && !toolCall.arguments().isEmpty()) {
                this.arguments.append(toolCall.arguments());
            }
        }

        AssistantMessage.ToolCall build() {
            return new AssistantMessage.ToolCall(this.id, this.type, this.name, this.arguments.toString());
        }
    }
}

