/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openaisdk;

import com.openai.azure.AzureOpenAIServiceVersion;
import com.openai.credential.Credential;
import com.openai.models.images.ImageGenerateParams;
import com.openai.models.images.ImageModel;
import java.net.Proxy;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.springframework.ai.image.ImageMessage;
import org.springframework.ai.image.ImageOptions;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.ai.openaisdk.AbstractOpenAiSdkOptions;

public class OpenAiSdkImageOptions
extends AbstractOpenAiSdkOptions
implements ImageOptions {
    public static final String DEFAULT_IMAGE_MODEL = ImageModel.DALL_E_3.toString();
    private Integer n;
    private Integer width;
    private Integer height;
    private String quality;
    private String responseFormat;
    private String size;
    private String style;
    private String user;

    public static Builder builder() {
        return new Builder();
    }

    public Integer getN() {
        return this.n;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
        this.size = this.width + "x" + this.height;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
        this.size = this.width + "x" + this.height;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(String responseFormat) {
        this.responseFormat = responseFormat;
    }

    public String getSize() {
        if (this.size != null) {
            return this.size;
        }
        return this.width != null && this.height != null ? this.width + "x" + this.height : null;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getQuality() {
        return this.quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenAiSdkImageOptions that = (OpenAiSdkImageOptions)o;
        return Objects.equals(this.n, that.n) && Objects.equals(this.width, that.width) && Objects.equals(this.height, that.height) && Objects.equals(this.quality, that.quality) && Objects.equals(this.responseFormat, that.responseFormat) && Objects.equals(this.size, that.size) && Objects.equals(this.style, that.style) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.n, this.width, this.height, this.quality, this.responseFormat, this.size, this.style, this.user);
    }

    public String toString() {
        return "OpenAiSdkImageOptions{n=" + this.n + ", width=" + this.width + ", height=" + this.height + ", quality='" + this.quality + "', responseFormat='" + this.responseFormat + "', size='" + this.size + "', style='" + this.style + "', user='" + this.user + "'}";
    }

    public ImageGenerateParams toOpenAiImageGenerateParams(ImagePrompt imagePrompt) {
        if (imagePrompt.getInstructions().isEmpty()) {
            throw new IllegalArgumentException("Image prompt instructions cannot be empty");
        }
        String prompt = ((ImageMessage)imagePrompt.getInstructions().get(0)).getText();
        ImageGenerateParams.Builder builder = ImageGenerateParams.builder().prompt(prompt);
        if (this.getDeploymentName() != null) {
            builder.model(this.getDeploymentName());
        } else if (this.getModel() != null) {
            builder.model(this.getModel());
        }
        if (this.getN() != null) {
            builder.n(this.getN().longValue());
        }
        if (this.getQuality() != null) {
            builder.quality(ImageGenerateParams.Quality.of((String)this.getQuality().toLowerCase()));
        }
        if (this.getResponseFormat() != null) {
            builder.responseFormat(ImageGenerateParams.ResponseFormat.of((String)this.getResponseFormat().toLowerCase()));
        }
        if (this.getSize() != null) {
            builder.size(ImageGenerateParams.Size.of((String)this.getSize()));
        }
        if (this.getStyle() != null) {
            builder.style(ImageGenerateParams.Style.of((String)this.getStyle().toLowerCase()));
        }
        if (this.getUser() != null) {
            builder.user(this.getUser());
        }
        return builder.build();
    }

    public static final class Builder {
        private final OpenAiSdkImageOptions options = new OpenAiSdkImageOptions();

        private Builder() {
        }

        public Builder from(OpenAiSdkImageOptions fromOptions) {
            this.options.setBaseUrl(fromOptions.getBaseUrl());
            this.options.setApiKey(fromOptions.getApiKey());
            this.options.setCredential(fromOptions.getCredential());
            this.options.setModel(fromOptions.getModel());
            this.options.setDeploymentName(fromOptions.getDeploymentName());
            this.options.setMicrosoftFoundryServiceVersion(fromOptions.getMicrosoftFoundryServiceVersion());
            this.options.setOrganizationId(fromOptions.getOrganizationId());
            this.options.setMicrosoftFoundry(fromOptions.isMicrosoftFoundry());
            this.options.setGitHubModels(fromOptions.isGitHubModels());
            this.options.setTimeout(fromOptions.getTimeout());
            this.options.setMaxRetries(fromOptions.getMaxRetries());
            this.options.setProxy(fromOptions.getProxy());
            this.options.setCustomHeaders(fromOptions.getCustomHeaders());
            this.options.setN(fromOptions.getN());
            this.options.setWidth(fromOptions.getWidth());
            this.options.setHeight(fromOptions.getHeight());
            this.options.setQuality(fromOptions.getQuality());
            this.options.setResponseFormat(fromOptions.getResponseFormat());
            this.options.setSize(fromOptions.getSize());
            this.options.setStyle(fromOptions.getStyle());
            this.options.setUser(fromOptions.getUser());
            return this;
        }

        public Builder merge(ImageOptions from) {
            if (from instanceof OpenAiSdkImageOptions) {
                OpenAiSdkImageOptions castFrom = (OpenAiSdkImageOptions)from;
                if (castFrom.getBaseUrl() != null) {
                    this.options.setBaseUrl(castFrom.getBaseUrl());
                }
                if (castFrom.getApiKey() != null) {
                    this.options.setApiKey(castFrom.getApiKey());
                }
                if (castFrom.getCredential() != null) {
                    this.options.setCredential(castFrom.getCredential());
                }
                if (castFrom.getModel() != null) {
                    this.options.setModel(castFrom.getModel());
                }
                if (castFrom.getDeploymentName() != null) {
                    this.options.setDeploymentName(castFrom.getDeploymentName());
                }
                if (castFrom.getMicrosoftFoundryServiceVersion() != null) {
                    this.options.setMicrosoftFoundryServiceVersion(castFrom.getMicrosoftFoundryServiceVersion());
                }
                if (castFrom.getOrganizationId() != null) {
                    this.options.setOrganizationId(castFrom.getOrganizationId());
                }
                this.options.setMicrosoftFoundry(castFrom.isMicrosoftFoundry());
                this.options.setGitHubModels(castFrom.isGitHubModels());
                if (castFrom.getTimeout() != null) {
                    this.options.setTimeout(castFrom.getTimeout());
                }
                if (castFrom.getMaxRetries() != null) {
                    this.options.setMaxRetries(castFrom.getMaxRetries());
                }
                if (castFrom.getProxy() != null) {
                    this.options.setProxy(castFrom.getProxy());
                }
                if (castFrom.getCustomHeaders() != null) {
                    this.options.setCustomHeaders(castFrom.getCustomHeaders());
                }
                if (castFrom.getN() != null) {
                    this.options.setN(castFrom.getN());
                }
                if (castFrom.getWidth() != null) {
                    this.options.setWidth(castFrom.getWidth());
                }
                if (castFrom.getHeight() != null) {
                    this.options.setHeight(castFrom.getHeight());
                }
                if (castFrom.getQuality() != null) {
                    this.options.setQuality(castFrom.getQuality());
                }
                if (castFrom.getResponseFormat() != null) {
                    this.options.setResponseFormat(castFrom.getResponseFormat());
                }
                if (castFrom.getSize() != null) {
                    this.options.setSize(castFrom.getSize());
                }
                if (castFrom.getStyle() != null) {
                    this.options.setStyle(castFrom.getStyle());
                }
                if (castFrom.getUser() != null) {
                    this.options.setUser(castFrom.getUser());
                }
            }
            return this;
        }

        public Builder N(Integer n) {
            this.options.setN(n);
            return this;
        }

        public Builder model(String model) {
            this.options.setModel(model);
            return this;
        }

        public Builder deploymentName(String deploymentName) {
            this.options.setDeploymentName(deploymentName);
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.options.setBaseUrl(baseUrl);
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.options.setApiKey(apiKey);
            return this;
        }

        public Builder credential(Credential credential) {
            this.options.setCredential(credential);
            return this;
        }

        public Builder azureOpenAIServiceVersion(AzureOpenAIServiceVersion azureOpenAIServiceVersion) {
            this.options.setMicrosoftFoundryServiceVersion(azureOpenAIServiceVersion);
            return this;
        }

        public Builder organizationId(String organizationId) {
            this.options.setOrganizationId(organizationId);
            return this;
        }

        public Builder azure(boolean azure) {
            this.options.setMicrosoftFoundry(azure);
            return this;
        }

        public Builder gitHubModels(boolean gitHubModels) {
            this.options.setGitHubModels(gitHubModels);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.options.setTimeout(timeout);
            return this;
        }

        public Builder maxRetries(Integer maxRetries) {
            this.options.setMaxRetries(maxRetries);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.options.setProxy(proxy);
            return this;
        }

        public Builder customHeaders(Map<String, String> customHeaders) {
            this.options.setCustomHeaders(customHeaders);
            return this;
        }

        public Builder responseFormat(String responseFormat) {
            this.options.setResponseFormat(responseFormat);
            return this;
        }

        public Builder width(Integer width) {
            this.options.setWidth(width);
            return this;
        }

        public Builder height(Integer height) {
            this.options.setHeight(height);
            return this;
        }

        public Builder user(String user) {
            this.options.setUser(user);
            return this;
        }

        public Builder style(String style) {
            this.options.setStyle(style);
            return this;
        }

        public OpenAiSdkImageOptions build() {
            return this.options;
        }
    }
}

