/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.tool.resolution;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.resolution.ToolCallbackResolver;
import org.springframework.util.Assert;

public class StaticToolCallbackResolver
implements ToolCallbackResolver {
    private static final Logger logger = LoggerFactory.getLogger(StaticToolCallbackResolver.class);
    private final Map<String, ToolCallback> toolCallbacks = new HashMap<String, ToolCallback>();

    public StaticToolCallbackResolver(List<ToolCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
        toolCallbacks.forEach(toolCallback -> this.toolCallbacks.put(toolCallback.getToolDefinition().name(), (ToolCallback)toolCallback));
    }

    @Override
    public @Nullable ToolCallback resolve(String toolName) {
        Assert.hasText((String)toolName, (String)"toolName cannot be null or empty");
        logger.debug("ToolCallback resolution attempt from static registry");
        return this.toolCallbacks.get(toolName);
    }
}

