/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model;

import java.util.ArrayList;
import java.util.List;

public final class EmbeddingUtils {
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];

    private EmbeddingUtils() {
    }

    public static List<Float> doubleToFloat(List<Double> doubles) {
        return doubles.stream().map(f -> Float.valueOf(f.floatValue())).toList();
    }

    public static float[] toPrimitive(List<Float> floats) {
        if (floats == null || floats.isEmpty()) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[floats.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = floats.get(i).floatValue();
        }
        return result;
    }

    public static float[] toPrimitive(Float[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    public static Float[] toFloatArray(float[] array) {
        if (array == null || array.length == 0) {
            return new Float[0];
        }
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    public static List<Float> toList(float[] floats) {
        ArrayList<Float> output = new ArrayList<Float>();
        for (float value : floats) {
            output.add(Float.valueOf(value));
        }
        return output;
    }
}

