/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.model;

import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.StreamingChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.Model;
import reactor.core.publisher.Flux;

public interface ChatModel
extends Model<Prompt, ChatResponse>,
StreamingChatModel {
    @Override
    default public @Nullable String call(String message) {
        Prompt prompt = new Prompt((Message)new UserMessage(message));
        Generation generation = this.call(prompt).getResult();
        return generation != null ? generation.getOutput().getText() : "";
    }

    @Override
    default public @Nullable String call(Message ... messages) {
        Prompt prompt = new Prompt(Arrays.asList(messages));
        Generation generation = this.call(prompt).getResult();
        return generation != null ? generation.getOutput().getText() : "";
    }

    @Override
    public ChatResponse call(Prompt var1);

    default public ChatOptions getDefaultOptions() {
        return ChatOptions.builder().build();
    }

    @Override
    default public Flux<ChatResponse> stream(Prompt prompt) {
        throw new UnsupportedOperationException("streaming is not supported");
    }
}

