/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.messages;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.chat.messages.AbstractMessage;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.content.Media;
import org.springframework.ai.content.MediaContent;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class AssistantMessage
extends AbstractMessage
implements MediaContent {
    private final List<ToolCall> toolCalls;
    protected final List<Media> media;

    public AssistantMessage(String content) {
        this(content, Map.of(), List.of(), List.of());
    }

    protected AssistantMessage(@Nullable String content, Map<String, Object> properties, List<ToolCall> toolCalls, List<Media> media) {
        super(MessageType.ASSISTANT, content, properties);
        Assert.notNull(toolCalls, (String)"Tool calls must not be null");
        Assert.notNull(media, (String)"Media must not be null");
        this.toolCalls = toolCalls;
        this.media = media;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public boolean hasToolCalls() {
        return !CollectionUtils.isEmpty(this.toolCalls);
    }

    public List<Media> getMedia() {
        return this.media;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssistantMessage)) {
            return false;
        }
        AssistantMessage that = (AssistantMessage)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.toolCalls, that.toolCalls) && Objects.equals(this.media, that.media);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.toolCalls, this.media);
    }

    public String toString() {
        return "AssistantMessage [messageType=" + String.valueOf((Object)this.messageType) + ", toolCalls=" + String.valueOf(this.toolCalls) + ", textContent=" + this.textContent + ", metadata=" + String.valueOf(this.metadata) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private @Nullable String content;
        private Map<String, Object> properties = Map.of();
        private List<ToolCall> toolCalls = List.of();
        private List<Media> media = List.of();

        private Builder() {
        }

        public Builder content(String content) {
            this.content = content;
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public Builder toolCalls(List<ToolCall> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        public Builder media(List<Media> media) {
            this.media = media;
            return this;
        }

        public AssistantMessage build() {
            return new AssistantMessage(this.content, this.properties, this.toolCalls, this.media);
        }
    }

    public record ToolCall(String id, String type, String name, String arguments) {
    }
}

