/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.prompt;

import java.util.List;
import org.springframework.ai.chat.prompt.DefaultChatOptionsBuilder;
import org.springframework.ai.model.ModelOptions;
import org.springframework.lang.Nullable;

public interface ChatOptions
extends ModelOptions {
    @Nullable
    public String getModel();

    @Nullable
    public Double getFrequencyPenalty();

    @Nullable
    public Integer getMaxTokens();

    @Nullable
    public Double getPresencePenalty();

    @Nullable
    public List<String> getStopSequences();

    @Nullable
    public Double getTemperature();

    @Nullable
    public Integer getTopK();

    @Nullable
    public Double getTopP();

    public <T extends ChatOptions> T copy();

    public static Builder builder() {
        return new DefaultChatOptionsBuilder();
    }

    public static interface Builder {
        public Builder model(String var1);

        public Builder frequencyPenalty(Double var1);

        public Builder maxTokens(Integer var1);

        public Builder presencePenalty(Double var1);

        public Builder stopSequences(List<String> var1);

        public Builder temperature(Double var1);

        public Builder topK(Integer var1);

        public Builder topP(Double var1);

        public ChatOptions build();
    }
}

