/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.tool.observation;

import io.micrometer.observation.Observation;
import org.springframework.ai.observation.AiOperationMetadata;
import org.springframework.ai.observation.conventions.AiOperationType;
import org.springframework.ai.observation.conventions.AiProvider;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.tool.metadata.ToolMetadata;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ToolCallingObservationContext
extends Observation.Context {
    private final AiOperationMetadata operationMetadata = new AiOperationMetadata(AiOperationType.FRAMEWORK.value(), AiProvider.SPRING_AI.value());
    private final ToolDefinition toolDefinition;
    private final ToolMetadata toolMetadata;
    private final String toolCallArguments;
    @Nullable
    private String toolCallResult;

    private ToolCallingObservationContext(ToolDefinition toolDefinition, ToolMetadata toolMetadata, String toolCallArguments, @Nullable String toolCallResult) {
        Assert.notNull((Object)toolDefinition, (String)"toolDefinition cannot be null");
        Assert.notNull((Object)toolMetadata, (String)"toolMetadata cannot be null");
        Assert.hasText((String)toolCallArguments, (String)"toolCallArguments cannot be null or empty");
        this.toolDefinition = toolDefinition;
        this.toolMetadata = toolMetadata;
        this.toolCallArguments = toolCallArguments;
        this.toolCallResult = toolCallResult;
    }

    public AiOperationMetadata getOperationMetadata() {
        return this.operationMetadata;
    }

    public ToolDefinition getToolDefinition() {
        return this.toolDefinition;
    }

    public ToolMetadata getToolMetadata() {
        return this.toolMetadata;
    }

    public String getToolCallArguments() {
        return this.toolCallArguments;
    }

    @Nullable
    public String getToolCallResult() {
        return this.toolCallResult;
    }

    public void setToolCallResult(@Nullable String toolCallResult) {
        this.toolCallResult = toolCallResult;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ToolDefinition toolDefinition;
        private ToolMetadata toolMetadata = ToolMetadata.builder().build();
        private String toolCallArguments;
        @Nullable
        private String toolCallResult;

        private Builder() {
        }

        public Builder toolDefinition(ToolDefinition toolDefinition) {
            this.toolDefinition = toolDefinition;
            return this;
        }

        public Builder toolMetadata(ToolMetadata toolMetadata) {
            this.toolMetadata = toolMetadata;
            return this;
        }

        public Builder toolCallArguments(String toolCallArguments) {
            this.toolCallArguments = toolCallArguments;
            return this;
        }

        public Builder toolCallResult(@Nullable String toolCallResult) {
            this.toolCallResult = toolCallResult;
            return this;
        }

        public ToolCallingObservationContext build() {
            return new ToolCallingObservationContext(this.toolDefinition, this.toolMetadata, this.toolCallArguments, this.toolCallResult);
        }
    }
}

