/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.milvus;

import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;

public class MilvusFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    protected void doExpression(Filter.Expression exp, StringBuilder context) {
        this.convertOperand(exp.left(), context);
        context.append(this.getOperationSymbol(exp));
        this.convertOperand(exp.right(), context);
    }

    private String getOperationSymbol(Filter.Expression exp) {
        return switch (exp.type()) {
            case Filter.ExpressionType.AND -> " && ";
            case Filter.ExpressionType.OR -> " || ";
            case Filter.ExpressionType.EQ -> " == ";
            case Filter.ExpressionType.NE -> " != ";
            case Filter.ExpressionType.LT -> " < ";
            case Filter.ExpressionType.LTE -> " <= ";
            case Filter.ExpressionType.GT -> " > ";
            case Filter.ExpressionType.GTE -> " >= ";
            case Filter.ExpressionType.IN -> " in ";
            case Filter.ExpressionType.NIN -> " not in ";
            default -> throw new RuntimeException("Not supported expression type:" + String.valueOf(exp.type()));
        };
    }

    protected void doGroup(Filter.Group group, StringBuilder context) {
        this.convertOperand((Filter.Operand)new Filter.Expression(Filter.ExpressionType.AND, (Filter.Operand)group.content(), (Filter.Operand)group.content()), context);
    }

    protected void doKey(Filter.Key key, StringBuilder context) {
        String identifier = this.hasOuterQuotes(key.key()) ? this.removeOuterQuotes(key.key()) : key.key();
        context.append("metadata[\"" + identifier + "\"]");
    }
}

