/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp;

import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.mcp.McpToolUtils;
import org.springframework.ai.mcp.ToolContextToMcpMetaConverter;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.definition.DefaultToolDefinition;
import org.springframework.ai.tool.definition.ToolDefinition;
import org.springframework.ai.tool.execution.ToolExecutionException;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class SyncMcpToolCallback
implements ToolCallback {
    private static final Logger logger = LoggerFactory.getLogger(SyncMcpToolCallback.class);
    private final McpSyncClient mcpClient;
    private final McpSchema.Tool tool;
    private final String prefixedToolName;
    private final ToolContextToMcpMetaConverter toolContextToMcpMetaConverter;

    @Deprecated
    public SyncMcpToolCallback(McpSyncClient mcpClient, McpSchema.Tool tool) {
        this(mcpClient, tool, McpToolUtils.prefixedToolName(mcpClient.getClientInfo().name(), mcpClient.getClientInfo().title(), tool.name()), ToolContextToMcpMetaConverter.defaultConverter());
    }

    private SyncMcpToolCallback(McpSyncClient mcpClient, McpSchema.Tool tool, String prefixedToolName, ToolContextToMcpMetaConverter toolContextToMcpMetaConverter) {
        Assert.notNull((Object)mcpClient, (String)"MCP client must not be null");
        Assert.notNull((Object)tool, (String)"MCP tool must not be null");
        Assert.hasText((String)prefixedToolName, (String)"Prefixed tool name must not be empty");
        Assert.notNull((Object)toolContextToMcpMetaConverter, (String)"ToolContextToMcpMetaConverter must not be null");
        this.mcpClient = mcpClient;
        this.tool = tool;
        this.prefixedToolName = prefixedToolName;
        this.toolContextToMcpMetaConverter = toolContextToMcpMetaConverter;
    }

    public ToolDefinition getToolDefinition() {
        return DefaultToolDefinition.builder().name(this.prefixedToolName).description(this.tool.description()).inputSchema(ModelOptionsUtils.toJsonString((Object)this.tool.inputSchema())).build();
    }

    public String getOriginalToolName() {
        return this.tool.name();
    }

    public String call(String toolCallInput) {
        return this.call(toolCallInput, null);
    }

    public String call(String toolCallInput, @Nullable ToolContext toolContext) {
        McpSchema.CallToolResult response;
        if (!StringUtils.hasText((String)toolCallInput)) {
            logger.warn("Tool call arguments are null or empty for MCP tool: {}. Using empty JSON object as default.", (Object)this.tool.name());
            toolCallInput = "{}";
        }
        Map arguments = ModelOptionsUtils.jsonToMap((String)toolCallInput);
        try {
            Map<String, Object> mcpMeta = toolContext != null ? this.toolContextToMcpMetaConverter.convert(toolContext) : null;
            McpSchema.CallToolRequest request = McpSchema.CallToolRequest.builder().name(this.tool.name()).arguments(arguments).meta(mcpMeta).build();
            response = this.mcpClient.callTool(request);
        }
        catch (Exception ex) {
            logger.error("Exception while tool calling: ", (Throwable)ex);
            throw new ToolExecutionException(this.getToolDefinition(), (Throwable)ex);
        }
        if (response.isError() != null && response.isError().booleanValue()) {
            logger.error("Error calling tool: {}", (Object)response.content());
            throw new ToolExecutionException(this.getToolDefinition(), (Throwable)new IllegalStateException("Error calling tool: " + String.valueOf(response.content())));
        }
        return ModelOptionsUtils.toJsonString((Object)response.content());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private McpSyncClient mcpClient;
        private McpSchema.Tool tool;
        private String prefixedToolName;
        private ToolContextToMcpMetaConverter toolContextToMcpMetaConverter = ToolContextToMcpMetaConverter.defaultConverter();

        public Builder mcpClient(McpSyncClient mcpClient) {
            this.mcpClient = mcpClient;
            return this;
        }

        public Builder tool(McpSchema.Tool tool) {
            this.tool = tool;
            return this;
        }

        public Builder prefixedToolName(String prefixedToolName) {
            this.prefixedToolName = prefixedToolName;
            return this;
        }

        public Builder toolContextToMcpMetaConverter(ToolContextToMcpMetaConverter toolContextToMcpMetaConverter) {
            Assert.notNull((Object)toolContextToMcpMetaConverter, (String)"ToolContextToMcpMetaConverter must not be null");
            this.toolContextToMcpMetaConverter = toolContextToMcpMetaConverter;
            return this;
        }

        public SyncMcpToolCallback build() {
            Assert.notNull((Object)this.mcpClient, (String)"MCP client must not be null");
            Assert.notNull((Object)this.tool, (String)"MCP tool must not be null");
            if (this.prefixedToolName == null) {
                this.prefixedToolName = McpToolUtils.format(this.tool.name());
            }
            return new SyncMcpToolCallback(this.mcpClient, this.tool, this.prefixedToolName, this.toolContextToMcpMetaConverter);
        }
    }
}

