/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.mariadb;

import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;
import org.springframework.util.Assert;

public class MariaDBFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    private final String metadataFieldName;

    public MariaDBFilterExpressionConverter(String metadataFieldName) {
        this.metadataFieldName = metadataFieldName;
    }

    protected void doExpression(Filter.Expression expression, StringBuilder context) {
        Assert.state((expression.right() != null ? 1 : 0) != 0, (String)"expected expression.right to be non null");
        this.convertOperand(expression.left(), context);
        context.append(this.getOperationSymbol(expression));
        this.convertOperand(expression.right(), context);
    }

    protected void doSingleValue(Object value, StringBuilder context) {
        if (value instanceof String) {
            context.append(String.format("'%s'", value));
        } else {
            context.append(value);
        }
    }

    private String getOperationSymbol(Filter.Expression exp) {
        return switch (exp.type()) {
            case Filter.ExpressionType.AND -> " AND ";
            case Filter.ExpressionType.OR -> " OR ";
            case Filter.ExpressionType.EQ -> " = ";
            case Filter.ExpressionType.NE -> " != ";
            case Filter.ExpressionType.LT -> " < ";
            case Filter.ExpressionType.LTE -> " <= ";
            case Filter.ExpressionType.GT -> " > ";
            case Filter.ExpressionType.GTE -> " >= ";
            case Filter.ExpressionType.IN -> " IN ";
            case Filter.ExpressionType.NOT, Filter.ExpressionType.NIN -> " NOT IN ";
            default -> throw new RuntimeException("Not supported expression type: " + String.valueOf(exp.type()));
        };
    }

    protected void doKey(Filter.Key key, StringBuilder context) {
        context.append("JSON_VALUE(" + this.metadataFieldName + ", '$." + key.key() + "')");
    }

    protected void doStartValueRange(Filter.Value listValue, StringBuilder context) {
        context.append("(");
    }

    protected void doEndValueRange(Filter.Value listValue, StringBuilder context) {
        context.append(")");
    }

    protected void doStartGroup(Filter.Group group, StringBuilder context) {
        context.append("(");
    }

    protected void doEndGroup(Filter.Group group, StringBuilder context) {
        context.append(")");
    }
}

