/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.infinispan;

import java.io.IOException;
import java.util.Date;
import org.infinispan.protostream.MessageMarshaller;
import org.springframework.ai.vectorstore.infinispan.SpringAiMetadata;

public class SpringAiMetadataMarshaller
implements MessageMarshaller<SpringAiMetadata> {
    private final String typeName;

    public SpringAiMetadataMarshaller(String typeName) {
        this.typeName = typeName;
    }

    public SpringAiMetadata readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        String name = reader.readString("name");
        String valueStr = reader.readString("value");
        Long valueInt = reader.readLong("value_int");
        Double valueFloat = reader.readDouble("value_float");
        Boolean valueBoolean = reader.readBoolean("value_bool");
        Date valueDate = reader.readDate("value_date");
        Object value = valueStr;
        if (value == null) {
            value = valueInt;
        }
        if (value == null) {
            value = valueFloat;
        }
        if (value == null) {
            value = valueBoolean;
        }
        if (value == null) {
            value = valueDate;
        }
        return new SpringAiMetadata(name, value);
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, SpringAiMetadata item) throws IOException {
        writer.writeString("name", item.name());
        String value = null;
        Long value_int = null;
        Double value_float = null;
        Boolean value_boolean = null;
        Date value_date = null;
        if (item.value() instanceof String) {
            value = (String)item.value();
        } else if (item.value() instanceof Integer) {
            value_int = ((Integer)item.value()).longValue();
        } else if (item.value() instanceof Long) {
            value_int = (Long)item.value();
        } else if (item.value() instanceof Float) {
            value_float = ((Float)item.value()).doubleValue();
        } else if (item.value() instanceof Double) {
            value_float = (Double)item.value();
        } else if (item.value() instanceof Boolean) {
            value_boolean = (Boolean)item.value();
        } else if (item.value() instanceof Date) {
            value_date = (Date)item.value();
        } else {
            value = item.value().toString();
        }
        writer.writeString("value", value);
        writer.writeLong("value_int", value_int);
        writer.writeDouble("value_float", value_float);
        writer.writeBoolean("value_bool", value_boolean);
        writer.writeDate("value_date", value_date);
    }

    public Class<? extends SpringAiMetadata> getJavaClass() {
        return SpringAiMetadata.class;
    }

    public String getTypeName() {
        return this.typeName;
    }
}

