/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.infinispan;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.protostream.MessageMarshaller;
import org.springframework.ai.vectorstore.infinispan.SpringAiInfinispanItem;
import org.springframework.ai.vectorstore.infinispan.SpringAiMetadata;

public class SpringAiItemMarshaller
implements MessageMarshaller<SpringAiInfinispanItem> {
    private final String typeName;

    public SpringAiItemMarshaller(String typeName) {
        this.typeName = typeName;
    }

    public SpringAiInfinispanItem readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        String id = reader.readString("id");
        String text = reader.readString("text");
        Set metadata = (Set)reader.readCollection("metadata", new HashSet(), SpringAiMetadata.class);
        float[] embedding = reader.readFloats("embedding");
        HashMap<String, Object> metadataMap = new HashMap<String, Object>();
        if (metadata != null) {
            for (SpringAiMetadata meta : metadata) {
                metadataMap.put(meta.name(), meta.value());
            }
        }
        return new SpringAiInfinispanItem(id, text, metadata, embedding, metadataMap);
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, SpringAiInfinispanItem item) throws IOException {
        writer.writeString("id", item.id());
        writer.writeString("text", item.text());
        writer.writeCollection("metadata", item.metadata(), SpringAiMetadata.class);
        writer.writeFloats("embedding", item.embedding());
    }

    public Class<? extends SpringAiInfinispanItem> getJavaClass() {
        return SpringAiInfinispanItem.class;
    }

    public String getTypeName() {
        return this.typeName;
    }
}

