/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.infinispan;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.StringConfiguration;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.schema.Field;
import org.infinispan.protostream.schema.Schema;
import org.infinispan.protostream.schema.Type;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.observation.conventions.VectorStoreProvider;
import org.springframework.ai.observation.conventions.VectorStoreSimilarityMetric;
import org.springframework.ai.vectorstore.AbstractVectorStoreBuilder;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.infinispan.InfinispanFilterExpressionConverter;
import org.springframework.ai.vectorstore.infinispan.SpringAiInfinispanItem;
import org.springframework.ai.vectorstore.infinispan.SpringAiItemMarshaller;
import org.springframework.ai.vectorstore.infinispan.SpringAiMetadata;
import org.springframework.ai.vectorstore.infinispan.SpringAiMetadataMarshaller;
import org.springframework.ai.vectorstore.observation.AbstractObservationVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class InfinispanVectorStore
extends AbstractObservationVectorStore
implements InitializingBean {
    public static final String DEFAULT_STORE_NAME = "defaultStore";
    public static final String DEFAULT_CACHE_CONFIG = "<distributed-cache name=\"CACHE_NAME\">\n<indexing storage=\"local-heap\">\n<indexed-entities>\n<indexed-entity>SPRING_AI_ITEM</indexed-entity>\n</indexed-entities>\n</indexing>\n</distributed-cache>";
    public static final String DEFAULT_PACKAGE = "dev.spring_ai";
    public static final String DEFAULT_ITEM_NAME = "SpringAiItem";
    public static final String DEFAULT_METADATA_ITEM = "SpringAiMetadata";
    public static final int DEFAULT_DISTANCE = 3;
    public static final String DEFAULT_SIMILARITY = VectorStoreSimilarityMetric.COSINE.value();
    private final RemoteCacheManager infinispanClient;
    private final String storeName;
    private final @Nullable String storeConfig;
    private final int distance;
    private final int dimension;
    private final String similarity;
    private final String schemaFileName;
    private final String packageName;
    private final String itemName;
    private final String metadataItemName;
    private final boolean registerSchema;
    private final boolean createStore;
    private final String itemFullName;
    private final String metadataFullName;
    private @Nullable RemoteCache<String, SpringAiInfinispanItem> remoteCache;

    protected InfinispanVectorStore(Builder builder) {
        super((AbstractVectorStoreBuilder)builder);
        Assert.notNull((Object)builder.infinispanClient, (String)"infinispanClientBuilder must not be null");
        Assert.notNull((Object)builder.dimension, (String)"dimension must not be null");
        Assert.isTrue((builder.distance == null || builder.distance != null && builder.distance > 0 ? 1 : 0) != 0, (String)"provided distance must be greater than 0");
        this.infinispanClient = builder.infinispanClient;
        this.dimension = builder.dimension;
        this.storeConfig = builder.storeConfig;
        this.createStore = builder.createStore == null ? true : builder.createStore;
        this.storeName = builder.storeName == null ? DEFAULT_STORE_NAME : builder.storeName;
        this.distance = builder.distance == null ? 3 : builder.distance;
        this.similarity = builder.similarity == null ? DEFAULT_SIMILARITY : builder.similarity;
        this.packageName = builder.packageName == null ? DEFAULT_PACKAGE : builder.packageName;
        this.itemName = builder.itemName == null ? DEFAULT_ITEM_NAME : builder.itemName;
        this.metadataItemName = builder.metadataItemName == null ? DEFAULT_METADATA_ITEM : builder.metadataItemName;
        this.registerSchema = builder.registerSchema == null ? true : builder.registerSchema;
        this.schemaFileName = this.getSchemaFileName(builder);
        this.itemFullName = this.computeProtoFullName(this.itemName);
        this.metadataFullName = this.computeProtoFullName(this.metadataItemName);
    }

    private String getSchemaFileName(Builder builder) {
        if (builder.schemaFileName != null) {
            return builder.schemaFileName;
        }
        return builder.packageName + ".dimension." + builder.dimension + ".proto";
    }

    private String computeProtoFullName(String name) {
        return this.packageName + "." + name;
    }

    public void doAdd(List<Document> documents) {
        Assert.notNull(this.remoteCache, (String)"remoteCache must not be null");
        HashMap<String, SpringAiInfinispanItem> elements = new HashMap<String, SpringAiInfinispanItem>(documents.size());
        List embeddings = this.embeddingModel.embed(documents, EmbeddingOptions.builder().build(), this.batchingStrategy);
        for (int i = 0; i < embeddings.size(); ++i) {
            Document document = documents.get(i);
            float[] vector = (float[])embeddings.get(i);
            Set<SpringAiMetadata> metadataSet = document.getMetadata().entrySet().stream().map(e -> new SpringAiMetadata((String)e.getKey(), e.getValue())).collect(Collectors.toSet());
            elements.put(document.getId(), new SpringAiInfinispanItem(document.getId(), document.getText(), metadataSet, vector, document.getMetadata()));
        }
        this.remoteCache.putAll(elements);
    }

    public void doDelete(List<String> idList) {
        Assert.notNull(this.remoteCache, (String)"remoteCache must not be null");
        if (idList == null || idList.isEmpty()) {
            throw new IllegalArgumentException("ids cannot be null or empty");
        }
        for (String id : idList) {
            this.remoteCache.remove((Object)id);
        }
    }

    public void doDelete(Filter.Expression filterExpression) {
        Assert.notNull(this.remoteCache, (String)"remoteCache must not be null");
        InfinispanFilterExpressionConverter filterExpressionConverter = new InfinispanFilterExpressionConverter();
        String filteringPart = filterExpressionConverter.convertExpression(filterExpression);
        String joinPart = filterExpressionConverter.doJoin();
        String deleteQuery = "DELETE FROM " + this.itemFullName + " i " + joinPart + " where " + filteringPart;
        Query query = this.remoteCache.query(deleteQuery);
        query.execute();
    }

    public List<Document> doSimilaritySearch(SearchRequest searchRequest) {
        Assert.notNull(this.remoteCache, (String)"remoteCache must not be null");
        String joinPart = "";
        Object filteringPart = "";
        if (searchRequest.hasFilterExpression() && searchRequest.getFilterExpression() != null) {
            InfinispanFilterExpressionConverter filterExpressionConverter = new InfinispanFilterExpressionConverter();
            filteringPart = "filtering(" + filterExpressionConverter.convertExpression(searchRequest.getFilterExpression()) + ")";
            joinPart = filterExpressionConverter.doJoin();
        }
        float[] embedding = this.embeddingModel.embed(searchRequest.getQuery());
        String vectorQuery = "select i, score(i) from " + this.itemFullName + " i " + joinPart + " where i.embedding <-> " + Arrays.toString(embedding) + "~" + this.distance + " " + (String)filteringPart;
        Query query = this.remoteCache.query(vectorQuery);
        List hits = query.maxResults(searchRequest.getTopK()).list();
        return hits.stream().map(obj -> {
            SpringAiInfinispanItem item = (SpringAiInfinispanItem)obj[0];
            Float score = (Float)obj[1];
            if (score.doubleValue() < searchRequest.getSimilarityThreshold()) {
                return null;
            }
            return Document.builder().id(item.id()).text(item.text()).metadata(item.metadataMap()).score(Double.valueOf(score.doubleValue())).build();
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void afterPropertiesSet() {
        Schema schema = this.buildSchema();
        ProtoStreamMarshaller marshaller = (ProtoStreamMarshaller)this.infinispanClient.getMarshallerRegistry().getMarshaller(ProtoStreamMarshaller.class);
        if (marshaller == null) {
            throw new IllegalStateException("ProtoStreamMarshaller not found");
        }
        marshaller.register(schema, new BaseMarshaller[]{new SpringAiMetadataMarshaller(this.metadataFullName), new SpringAiItemMarshaller(this.itemFullName)});
        if (this.registerSchema) {
            this.infinispanClient.administration().schemas().createOrUpdate(schema);
        }
        if (this.infinispanClient.administration().schemas().get(this.schemaFileName).isEmpty()) {
            throw new IllegalStateException("SpringAI Schema '" + this.schemaFileName + "' not found");
        }
        ProtoStreamMarshaller finalMarshaller = marshaller;
        this.infinispanClient.getConfiguration().addRemoteCache(this.storeName, c -> c.marshaller((Marshaller)finalMarshaller));
        this.remoteCache = this.infinispanClient.getCache(this.storeName);
        if (this.remoteCache == null && this.createStore) {
            String infinispanCacheConfig = this.storeConfig;
            if (infinispanCacheConfig == null) {
                infinispanCacheConfig = DEFAULT_CACHE_CONFIG.replace("CACHE_NAME", this.storeName).replace("SPRING_AI_ITEM", this.itemFullName);
            }
            this.remoteCache = this.infinispanClient.administration().getOrCreateCache(this.storeName, (BasicConfiguration)new StringConfiguration(infinispanCacheConfig));
        }
        if (this.remoteCache == null) {
            throw new IllegalStateException("Infinispan Cache '" + this.storeName + "' not found");
        }
    }

    private Schema buildSchema() {
        Field.Builder schemaBuilder = new Schema.Builder(this.schemaFileName).packageName(this.packageName).addMessage(this.metadataItemName).addComment("@Indexed").addField((Type)Type.Scalar.STRING, "name", 1).addComment("@Basic(projectable=true)").addField((Type)Type.Scalar.STRING, "value", 2).addComment("@Basic(projectable=true)").addField((Type)Type.Scalar.INT64, "value_int", 3).addComment("@Basic(projectable=true)").addField((Type)Type.Scalar.DOUBLE, "value_float", 4).addComment("@Basic(projectable=true)").addField((Type)Type.Scalar.BOOL, "value_bool", 5).addComment("@Basic(projectable=true)").addField((Type)Type.Scalar.FIXED64, "value_date", 6).addComment("@Basic(projectable=true)").addMessage(this.itemName).addComment("@Indexed").addField((Type)Type.Scalar.STRING, "id", 1).addComment("@Basic(projectable=true)").addField((Type)Type.Scalar.STRING, "text", 2).addComment("@Basic(projectable=true)");
        schemaBuilder.addRepeatedField(Type.create((String)this.metadataItemName), "metadata", 3).addComment("@Embedded");
        schemaBuilder.addRepeatedField((Type)Type.Scalar.FLOAT, "embedding", 4).addComment(String.format("@Vector(dimension=%d, similarity=%s)", this.dimension, this.similarity.toUpperCase()));
        return schemaBuilder.build();
    }

    public VectorStoreObservationContext.Builder createObservationContextBuilder(String operationName) {
        return VectorStoreObservationContext.builder((String)VectorStoreProvider.INFINISPAN.value(), (String)operationName).collectionName(this.storeName).dimensions(Integer.valueOf(this.embeddingModel.dimensions())).similarityMetric(this.similarity);
    }

    public <T> Optional<T> getNativeClient() {
        RemoteCache<String, SpringAiInfinispanItem> client = this.remoteCache;
        return Optional.ofNullable(client);
    }

    public static Builder builder(RemoteCacheManager infinispanClient, EmbeddingModel embeddingModel) {
        return new Builder(infinispanClient, embeddingModel);
    }

    public void clear() {
        Assert.notNull(this.remoteCache, (String)"remoteCache must not be null");
        this.remoteCache.clear();
    }

    public static class Builder
    extends AbstractVectorStoreBuilder<Builder> {
        private RemoteCacheManager infinispanClient;
        private final @Nullable Integer dimension;
        private @Nullable Boolean createStore;
        private @Nullable String storeName;
        private @Nullable String storeConfig;
        private @Nullable Integer distance;
        private @Nullable String similarity;
        private @Nullable String schemaFileName;
        private @Nullable String packageName;
        private @Nullable String itemName;
        private @Nullable String metadataItemName;
        private @Nullable Boolean registerSchema;

        public Builder storeName(String name) {
            this.storeName = name;
            return this;
        }

        public Builder storeConfig(String storeConfig) {
            this.storeConfig = storeConfig;
            return this;
        }

        public Builder distance(Integer distance) {
            this.distance = distance;
            return this;
        }

        public Builder similarity(String similarity) {
            this.similarity = similarity;
            return this;
        }

        public Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder springAiItemName(String itemName) {
            this.itemName = itemName;
            return this;
        }

        public Builder metadataItemName(String metadataItemName) {
            this.metadataItemName = metadataItemName;
            return this;
        }

        public Builder registerSchema(Boolean registerSchema) {
            this.registerSchema = registerSchema;
            return this;
        }

        public Builder createStore(Boolean create) {
            this.createStore = create;
            return this;
        }

        public Builder schemaFileName(String schemaFileName) {
            this.schemaFileName = schemaFileName;
            return this;
        }

        public Builder(RemoteCacheManager infinispanClient, EmbeddingModel embeddingModel) {
            super(embeddingModel);
            Assert.notNull((Object)infinispanClient, (String)"infinispanClient must not be null");
            this.infinispanClient = infinispanClient;
            this.dimension = embeddingModel.dimensions();
        }

        public InfinispanVectorStore build() {
            return new InfinispanVectorStore(this);
        }
    }
}

