/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.infinispan;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;
import org.springframework.util.Assert;

class InfinispanFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    private static final Pattern DATE_FORMAT_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(ZoneOffset.UTC);
    private int i = -1;

    InfinispanFilterExpressionConverter() {
    }

    public String doJoin() {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j <= this.i; ++j) {
            sb.append(" join i.metadata m").append(j);
        }
        return sb.toString();
    }

    protected void doExpression(Filter.Expression expression, StringBuilder context) {
        switch (expression.type()) {
            case AND: {
                context.append("((");
                this.doExpression(InfinispanFilterExpressionConverter.convertToFilterExpression(expression.left()), context);
                context.append(") AND (");
                this.doExpression(InfinispanFilterExpressionConverter.convertToFilterExpression(expression.right()), context);
                context.append("))");
                break;
            }
            case OR: {
                context.append("((");
                this.doExpression(InfinispanFilterExpressionConverter.convertToFilterExpression(expression.left()), context);
                context.append(") OR (");
                this.doExpression(InfinispanFilterExpressionConverter.convertToFilterExpression(expression.right()), context);
                context.append("))");
                break;
            }
            default: {
                this.doField(expression, context);
            }
        }
    }

    protected void doKey(Filter.Key filterKey, StringBuilder context) {
    }

    public void doStartGroup(Filter.Group group, StringBuilder context) {
        context.append("(");
    }

    public void doEndGroup(Filter.Group group, StringBuilder context) {
        context.append(")");
    }

    private static Filter.Expression convertToFilterExpression(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Filter.Operand expression) {
        if (expression instanceof Filter.Expression) {
            return (Filter.Expression)expression;
        }
        throw new IllegalArgumentException("Expected a Filter expression");
    }

    private void doField(Filter.Expression expression, StringBuilder context) {
        Filter.Key key = (Filter.Key)expression.left();
        Filter.Value value = (Filter.Value)expression.right();
        String result = switch (expression.type()) {
            case Filter.ExpressionType.EQ -> this.mapEqual(key, value, true);
            case Filter.ExpressionType.NE -> this.mapEqual(key, value, false);
            case Filter.ExpressionType.GT -> this.mapGreaterThan(key, value);
            case Filter.ExpressionType.GTE -> this.mapGreaterThanEqual(key, value);
            case Filter.ExpressionType.LT -> this.mapLessThan(key, value);
            case Filter.ExpressionType.LTE -> this.mapLessThanEqual(key, value);
            case Filter.ExpressionType.IN -> this.mapIn(key, value, true);
            case Filter.ExpressionType.NIN -> this.mapIn(key, value, false);
            case Filter.ExpressionType.ISNULL -> this.mapIsNull(key);
            case Filter.ExpressionType.ISNOTNULL -> this.mapIsNotNull(key);
            default -> throw new UnsupportedOperationException("Unsupported value: " + String.valueOf(expression.type()));
        };
        context.append(result);
    }

    private String mapIsNull(Filter.Key key) {
        this.incrementJoin();
        String m = "m" + this.i + ".";
        return "(" + this.metadataKey(key) + String.format("%svalue IS NULL and %svalue_int IS NULL and %svalue_date IS NULL and %svalue_float IS NULL and %svalue_bool IS NULL)", m, m, m, m, m) + " OR (" + m + "name NOT IN('" + key.key() + "'))";
    }

    private String mapIsNotNull(Filter.Key key) {
        this.incrementJoin();
        String m = "m" + this.i + ".";
        return this.metadataKey(key) + String.format("(%svalue IS NOT NULL or %svalue_int IS NOT NULL or %svalue_date IS NOT NULL or %svalue_float IS NOT NULL or %svalue_bool IS NOT NULL)", m, m, m, m, m);
    }

    private String mapEqual(Filter.Key key, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Filter.Value value, boolean equals) {
        Assert.notNull((Object)value, (String)"value must not be null");
        this.incrementJoin();
        String filter = this.metadataKey(key) + this.computeValue(equals ? "=" : "!=", value.value());
        if (equals) {
            return filter;
        }
        return filter + " " + this.addMetadataNullCheck();
    }

    private String mapGreaterThan(Filter.Key key, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Filter.Value value) {
        Assert.notNull((Object)value, (String)"value must not be null");
        this.incrementJoin();
        return this.metadataKey(key) + this.computeValue(">", value.value());
    }

    private String mapGreaterThanEqual(Filter.Key key, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Filter.Value value) {
        Assert.notNull((Object)value, (String)"value must not be null");
        this.incrementJoin();
        return this.metadataKey(key) + this.computeValue(">=", value.value());
    }

    private String mapLessThan(Filter.Key key, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Filter.Value value) {
        Assert.notNull((Object)value, (String)"value must not be null");
        this.incrementJoin();
        return this.metadataKey(key) + this.computeValue("<", value.value());
    }

    private String mapLessThanEqual(Filter.Key key, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Filter.Value value) {
        Assert.notNull((Object)value, (String)"value must not be null");
        this.incrementJoin();
        return this.metadataKey(key) + this.computeValue("<=", value.value());
    }

    private String mapIn(Filter.Key key, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Filter.Value value, boolean in) {
        Object inStatement;
        Object first;
        Assert.notNull((Object)value, (String)"value must not be null");
        this.incrementJoin();
        Object object = value.value();
        if (object instanceof List) {
            List values = (List)object;
            if (values.isEmpty()) {
                throw new UnsupportedOperationException("Infinispan metadata filter IN must contain values");
            }
            first = values.get(0);
            inStatement = this.formattedComparisonValues(values);
        } else {
            first = value.value();
            inStatement = first instanceof String ? "'" + String.valueOf(value.value()) + "'" : value.value().toString();
        }
        String m = "m" + this.i + ".";
        String inFilter = m + "value IN (" + (String)inStatement + ")";
        if (first instanceof Integer || first instanceof Long) {
            inFilter = m + "value_int IN (" + (String)inStatement + ")";
        } else if (first instanceof Float || first instanceof Double) {
            inFilter = m + "value_float IN (" + (String)inStatement + ")";
        } else if (first instanceof Boolean) {
            inFilter = m + "value_bool IN (" + (String)inStatement + ")";
        } else if (first instanceof Date) {
            inFilter = m + "value_date IN (" + (String)inStatement + ")";
        }
        if (in) {
            return this.metadataKey(key) + inFilter;
        }
        String notInFilter = m + "value NOT IN (" + (String)inStatement + ")";
        if (first instanceof Integer || first instanceof Long) {
            notInFilter = m + "value_int NOT IN (" + (String)inStatement + ")";
        } else if (first instanceof Float || first instanceof Double) {
            notInFilter = m + "value_float NOT IN (" + (String)inStatement + ")";
        }
        return "(" + notInFilter + this.metadataKeyLast(key) + ") OR (" + inFilter + " and " + m + "name!='" + key.key() + "') " + this.addMetadataNullCheck();
    }

    private String metadataKey(Filter.Key key) {
        return "m" + this.i + ".name='" + key.key() + "' and ";
    }

    private String metadataKeyLast(Filter.Key key) {
        return " and m" + this.i + ".name='" + key.key() + "' ";
    }

    private String computeValue(String operator, Object value) {
        String text;
        String m = "m" + this.i + ".";
        Object filterQuery = "";
        if (value instanceof String && DATE_FORMAT_PATTERN.matcher(text = (String)value).matches()) {
            try {
                filterQuery = m + "value_date" + operator + Instant.from(DATE_TIME_FORMATTER.parse(text)).toEpochMilli();
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Invalid date type:" + text, e);
            }
        } else if (value instanceof Integer || value instanceof Long) {
            Long longValue = this.getLongValue(value);
            filterQuery = m + "value_int" + operator + longValue;
        } else if (value instanceof Float || value instanceof Double) {
            Double doubleValue = this.getDoubleValue(value);
            filterQuery = m + "value_float" + operator + doubleValue;
        } else if (value instanceof Date || value instanceof Instant) {
            filterQuery = m + "value_date" + operator + this.getDate(value);
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            filterQuery = m + "value_bool" + operator + bool;
        } else {
            filterQuery = m + "value" + operator + "'" + String.valueOf(value) + "'";
        }
        return filterQuery;
    }

    private long getDate(Object value) {
        if (value instanceof Date) {
            Date date = (Date)value;
            return date.toInstant().toEpochMilli();
        }
        if (value instanceof Instant) {
            Instant instant = (Instant)value;
            return instant.toEpochMilli();
        }
        return 0L;
    }

    private Long getLongValue(Object value) {
        return value instanceof Integer ? ((Integer)value).longValue() : ((Long)value).longValue();
    }

    private Double getDoubleValue(Object value) {
        return value instanceof Float ? ((Float)value).doubleValue() : ((Double)value).doubleValue();
    }

    private String formattedComparisonValues(Collection<?> comparisonValues) {
        String inStatement = comparisonValues.stream().map(s -> s instanceof String || s instanceof Date ? "'" + String.valueOf(s) + "'" : s.toString()).collect(Collectors.joining(", "));
        return inStatement;
    }

    private String addMetadataNullCheck() {
        return "OR (i.metadata is null)";
    }

    private void incrementJoin() {
        ++this.i;
    }
}

