/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.google.genai.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.MediaModality;
import com.google.genai.types.ModalityTokenCount;

public class GoogleGenAiModalityTokenCount {
    private final String modality;
    private final Integer tokenCount;

    public GoogleGenAiModalityTokenCount(String modality, Integer tokenCount) {
        this.modality = modality;
        this.tokenCount = tokenCount;
    }

    public static GoogleGenAiModalityTokenCount from(ModalityTokenCount modalityTokenCount) {
        if (modalityTokenCount == null) {
            return null;
        }
        String modalityStr = modalityTokenCount.modality().map(GoogleGenAiModalityTokenCount::convertModality).orElse("UNKNOWN");
        Integer tokens = modalityTokenCount.tokenCount().orElse(0);
        return new GoogleGenAiModalityTokenCount(modalityStr, tokens);
    }

    private static String convertModality(MediaModality modality) {
        String modalityStr;
        if (modality == null) {
            return "UNKNOWN";
        }
        return switch (modalityStr = modality.toString().toUpperCase()) {
            case "TEXT", "IMAGE", "VIDEO", "AUDIO", "DOCUMENT" -> modalityStr;
            case "MODALITY_UNSPECIFIED", "MEDIA_MODALITY_UNSPECIFIED" -> "UNKNOWN";
            default -> modalityStr;
        };
    }

    @JsonProperty(value="modality")
    public String getModality() {
        return this.modality;
    }

    @JsonProperty(value="tokenCount")
    public Integer getTokenCount() {
        return this.tokenCount;
    }

    public String toString() {
        return "GoogleGenAiModalityTokenCount{modality='" + this.modality + "', tokenCount=" + this.tokenCount + "}";
    }
}

