/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.google.genai;

import com.google.genai.Client;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class GoogleGenAiEmbeddingConnectionDetails {
    public static final String DEFAULT_LOCATION = "us-central1";
    public static final String DEFAULT_PUBLISHER = "google";
    private final String projectId;
    private final String location;
    private final String apiKey;
    private final Client genAiClient;

    private GoogleGenAiEmbeddingConnectionDetails(String projectId, String location, String apiKey, Client genAiClient) {
        this.projectId = projectId;
        this.location = location;
        this.apiKey = apiKey;
        this.genAiClient = genAiClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Client getGenAiClient() {
        return this.genAiClient;
    }

    public String getModelEndpointName(String modelName) {
        return modelName;
    }

    public static final class Builder {
        private String projectId;
        private String location;
        private String apiKey;
        private Client genAiClient;

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder genAiClient(Client genAiClient) {
            this.genAiClient = genAiClient;
            return this;
        }

        public GoogleGenAiEmbeddingConnectionDetails build() {
            if (this.genAiClient != null) {
                return new GoogleGenAiEmbeddingConnectionDetails(this.projectId, this.location, this.apiKey, this.genAiClient);
            }
            Client.Builder clientBuilder = Client.builder();
            if (StringUtils.hasText((String)this.apiKey)) {
                clientBuilder.apiKey(this.apiKey);
            } else {
                Assert.hasText((String)this.projectId, (String)"Project ID must be provided for Vertex AI mode");
                if (!StringUtils.hasText((String)this.location)) {
                    this.location = GoogleGenAiEmbeddingConnectionDetails.DEFAULT_LOCATION;
                }
                clientBuilder.project(this.projectId).location(this.location).vertexAI(true);
            }
            Client builtClient = clientBuilder.build();
            return new GoogleGenAiEmbeddingConnectionDetails(this.projectId, this.location, this.apiKey, builtClient);
        }
    }
}

