/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.gemfire;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentMetadata;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.observation.conventions.VectorStoreProvider;
import org.springframework.ai.util.JacksonUtils;
import org.springframework.ai.vectorstore.AbstractVectorStoreBuilder;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.filter.FilterExpressionConverter;
import org.springframework.ai.vectorstore.gemfire.BearerTokenAuthenticationFilterFunction;
import org.springframework.ai.vectorstore.gemfire.GemFireAiSearchFilterExpressionConverter;
import org.springframework.ai.vectorstore.observation.AbstractObservationVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ExchangeFilterFunctions;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientException;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

public class GemFireVectorStore
extends AbstractObservationVectorStore
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(GemFireVectorStore.class);
    private static final String DEFAULT_URI = "http{ssl}://{host}:{port}/gemfire-vectordb/v1/indexes";
    private static final String EMBEDDINGS = "/embeddings";
    private static final String QUERY = "/query";
    private static final String DOCUMENT_FIELD = "document";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_INDEX_NAME = "spring-ai-gemfire-index";
    public static final int UPPER_BOUND_BEAM_WIDTH = 3200;
    public static final int DEFAULT_BEAM_WIDTH = 100;
    private static final int UPPER_BOUND_MAX_CONNECTIONS = 512;
    public static final int DEFAULT_MAX_CONNECTIONS = 16;
    public static final String DEFAULT_SIMILARITY_FUNCTION = "COSINE";
    public static final String[] DEFAULT_FIELDS = new String[0];
    public static final int DEFAULT_BUCKETS = 0;
    public static final boolean DEFAULT_SSL_ENABLED = false;
    private final WebClient client;
    private final boolean initializeSchema;
    private final ObjectMapper objectMapper;
    private final String indexName;
    private final int beamWidth;
    private final int maxConnections;
    private final int buckets;
    private final String vectorSimilarityFunction;
    private final String[] fields;
    private final FilterExpressionConverter filterExpressionConverter;

    protected GemFireVectorStore(Builder builder) {
        super((AbstractVectorStoreBuilder)builder);
        this.initializeSchema = builder.initializeSchema;
        this.indexName = builder.indexName;
        this.beamWidth = builder.beamWidth;
        this.maxConnections = builder.maxConnections;
        this.buckets = builder.buckets;
        this.vectorSimilarityFunction = builder.vectorSimilarityFunction;
        this.fields = builder.fields;
        String base = UriComponentsBuilder.fromUriString((String)DEFAULT_URI).build(new Object[]{builder.sslEnabled ? "s" : "", builder.host, builder.port}).toString();
        WebClient.Builder webClientBuilder = WebClient.builder().baseUrl(base);
        BearerTokenAuthenticationFilterFunction authenticationFilterFunction = null;
        if (builder.isUsingTokenAuthentication()) {
            Assert.state((builder.token != null ? 1 : 0) != 0, (String)"builder.token can't be null");
            authenticationFilterFunction = new BearerTokenAuthenticationFilterFunction(builder.token);
        } else if (builder.isUsingBasicAuthentication()) {
            Assert.state((builder.username != null && builder.password != null ? 1 : 0) != 0, (String)"builder.username and password can't be null");
            authenticationFilterFunction = ExchangeFilterFunctions.basicAuthentication((String)builder.username, (String)builder.password);
        }
        if (authenticationFilterFunction != null) {
            webClientBuilder.filter(authenticationFilterFunction);
        }
        this.client = webClientBuilder.build();
        this.filterExpressionConverter = new GemFireAiSearchFilterExpressionConverter();
        this.objectMapper = ((JsonMapper.Builder)JsonMapper.builder().addModules((Iterable)JacksonUtils.instantiateAvailableModules())).build();
    }

    public static Builder builder(EmbeddingModel embeddingModel) {
        return new Builder(embeddingModel);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int getBeamWidth() {
        return this.beamWidth;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getBuckets() {
        return this.buckets;
    }

    public String getVectorSimilarityFunction() {
        return this.vectorSimilarityFunction;
    }

    public String[] getFields() {
        return this.fields;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.initializeSchema) {
            return;
        }
        if (!this.indexExists()) {
            this.createIndex();
        }
    }

    public boolean indexExists() {
        String indexResponse = this.getIndex();
        return indexResponse != null && !indexResponse.isEmpty();
    }

    public @Nullable String getIndex() {
        return (String)this.client.get().uri("/" + this.indexName, new Object[0]).retrieve().bodyToMono(String.class).onErrorReturn((Object)"").block();
    }

    public void doAdd(List<Document> documents) {
        List embeddings = this.embeddingModel.embed(documents, EmbeddingOptions.builder().build(), this.batchingStrategy);
        UploadRequest upload = new UploadRequest(documents.stream().map(document -> new UploadRequest.Embedding(document.getId(), (float[])embeddings.get(documents.indexOf(document)), DOCUMENT_FIELD, Objects.requireNonNullElse(document.getText(), ""), document.getMetadata())).toList());
        String embeddingsJson = null;
        try {
            String embeddingString = this.objectMapper.writeValueAsString((Object)upload);
            embeddingsJson = embeddingString.substring("{\"embeddings\":".length());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(String.format("Embedding JSON parsing error: %s", e.getMessage()));
        }
        ((WebClient.RequestBodySpec)this.client.post().uri("/" + this.indexName + EMBEDDINGS, new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)embeddingsJson).retrieve().bodyToMono(Void.class).onErrorMap(WebClientException.class, this::handleHttpClientException).block();
    }

    public void doDelete(List<String> idList) {
        try {
            ((WebClient.RequestBodySpec)this.client.method(HttpMethod.DELETE).uri("/" + this.indexName + EMBEDDINGS, new Object[0])).body(BodyInserters.fromValue(idList)).retrieve().bodyToMono(Void.class).block();
        }
        catch (Exception e) {
            logger.warn("Error removing embedding: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public List<Document> doSimilaritySearch(SearchRequest request) {
        String filterQuery = null;
        if (request.hasFilterExpression()) {
            Assert.notNull((Object)request.getFilterExpression(), (String)"filterExpression should not be null");
            filterQuery = this.filterExpressionConverter.convertExpression(request.getFilterExpression());
        }
        float[] floatVector = this.embeddingModel.embed(request.getQuery());
        List result = (List)((WebClient.RequestBodySpec)this.client.post().uri("/" + this.indexName + QUERY, new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)new QueryRequest(floatVector, request.getTopK(), request.getTopK(), true, filterQuery)).retrieve().bodyToFlux(QueryResponse.class).filter(r -> (double)r.score >= request.getSimilarityThreshold()).map(r -> {
            Map<String, Object> metadata = r.metadata;
            if (r.metadata == null) {
                metadata = new HashMap<String, Object>();
                metadata.put(DOCUMENT_FIELD, "--Deleted--");
            }
            metadata.put(DocumentMetadata.DISTANCE.value(), Float.valueOf(1.0f - r.score));
            String content = (String)metadata.remove(DOCUMENT_FIELD);
            return Document.builder().id(r.key).text(content).metadata(metadata).score(Double.valueOf(r.score)).build();
        }).collectList().onErrorMap(WebClientException.class, this::handleHttpClientException).block();
        return Objects.requireNonNullElse(result, List.of());
    }

    public void createIndex() throws JsonProcessingException {
        CreateRequest createRequest = new CreateRequest(this.indexName, this.beamWidth, this.maxConnections, this.vectorSimilarityFunction, this.fields, this.buckets);
        String index = this.objectMapper.writeValueAsString((Object)createRequest);
        this.client.post().contentType(MediaType.APPLICATION_JSON).bodyValue((Object)index).retrieve().bodyToMono(Void.class).onErrorMap(WebClientException.class, this::handleHttpClientException).block();
    }

    public void deleteIndex() {
        DeleteRequest deleteRequest = new DeleteRequest();
        ((WebClient.RequestBodySpec)this.client.method(HttpMethod.DELETE).uri("/" + this.indexName, new Object[0])).body(BodyInserters.fromValue((Object)deleteRequest)).retrieve().bodyToMono(Void.class).onErrorMap(WebClientException.class, this::handleHttpClientException).block();
    }

    private Throwable handleHttpClientException(Throwable ex) {
        if (!(ex instanceof WebClientResponseException)) {
            throw new RuntimeException(String.format("Got an unexpected error: %s", ex));
        }
        WebClientResponseException clientException = (WebClientResponseException)ex;
        if (clientException.getStatusCode().equals((Object)HttpStatus.NOT_FOUND)) {
            throw new RuntimeException(String.format("Index %s not found: %s", this.indexName, ex));
        }
        if (clientException.getStatusCode().equals((Object)HttpStatus.BAD_REQUEST)) {
            throw new RuntimeException(String.format("Bad Request: %s", ex));
        }
        throw new RuntimeException(String.format("Got an unexpected HTTP error: %s", ex));
    }

    public VectorStoreObservationContext.Builder createObservationContextBuilder(String operationName) {
        return VectorStoreObservationContext.builder((String)VectorStoreProvider.GEMFIRE.value(), (String)operationName).collectionName(this.indexName).dimensions(Integer.valueOf(this.embeddingModel.dimensions())).fieldName(EMBEDDINGS);
    }

    public static class Builder
    extends AbstractVectorStoreBuilder<Builder> {
        private String host = "localhost";
        private int port = 8080;
        private boolean sslEnabled = false;
        private String indexName = "spring-ai-gemfire-index";
        private int beamWidth = 100;
        private int maxConnections = 16;
        private int buckets = 0;
        private String vectorSimilarityFunction = "COSINE";
        private String[] fields = DEFAULT_FIELDS;
        private boolean initializeSchema = false;
        private @Nullable String username;
        private @Nullable String password;
        private @Nullable String token;

        private Builder(EmbeddingModel embeddingModel) {
            super(embeddingModel);
        }

        public Builder host(String host) {
            Assert.hasText((String)host, (String)"host must have a value");
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            Assert.isTrue((port > 0 ? 1 : 0) != 0, (String)"port must be positive");
            this.port = port;
            return this;
        }

        public Builder sslEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        public Builder indexName(String indexName) {
            Assert.hasText((String)indexName, (String)"indexName must have a value");
            this.indexName = indexName;
            return this;
        }

        public Builder beamWidth(int beamWidth) {
            Assert.isTrue((beamWidth > 0 ? 1 : 0) != 0, (String)"beamWidth must be positive");
            Assert.isTrue((beamWidth <= 3200 ? 1 : 0) != 0, (String)"beamWidth must be less than or equal to 3200");
            this.beamWidth = beamWidth;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            Assert.isTrue((maxConnections > 0 ? 1 : 0) != 0, (String)"maxConnections must be positive");
            Assert.isTrue((maxConnections <= 512 ? 1 : 0) != 0, (String)"maxConnections must be less than or equal to 512");
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder buckets(int buckets) {
            Assert.isTrue((buckets >= 0 ? 1 : 0) != 0, (String)"buckets must not be negative");
            this.buckets = buckets;
            return this;
        }

        public Builder vectorSimilarityFunction(String vectorSimilarityFunction) {
            Assert.hasText((String)vectorSimilarityFunction, (String)"vectorSimilarityFunction must have a value");
            this.vectorSimilarityFunction = vectorSimilarityFunction;
            return this;
        }

        public Builder fields(String[] fields) {
            this.fields = fields;
            return this;
        }

        public Builder initializeSchema(boolean initializeSchema) {
            this.initializeSchema = initializeSchema;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public boolean isUsingTokenAuthentication() {
            return this.token != null;
        }

        public boolean isUsingBasicAuthentication() {
            return this.username != null && this.password != null;
        }

        public GemFireVectorStore build() {
            return new GemFireVectorStore(this);
        }
    }

    private static final class UploadRequest {
        private final List<Embedding> embeddings;

        public List<Embedding> getEmbeddings() {
            return this.embeddings;
        }

        @JsonCreator
        UploadRequest(@JsonProperty(value="embeddings") List<Embedding> embeddings) {
            this.embeddings = embeddings;
        }

        private static final class Embedding {
            private final String key;
            private final float[] vector;
            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            private Map<String, Object> metadata;

            Embedding(@JsonProperty(value="key") String key, @JsonProperty(value="vector") float[] vector, String contentName, String content, @JsonProperty(value="metadata") Map<String, Object> metadata) {
                this.key = key;
                this.vector = vector;
                this.metadata = new HashMap<String, Object>(metadata);
                this.metadata.put(contentName, content);
            }

            public String getKey() {
                return this.key;
            }

            public float[] getVector() {
                return this.vector;
            }

            public Map<String, Object> getMetadata() {
                return this.metadata;
            }
        }
    }

    private static final class QueryRequest {
        @JsonProperty(value="vector")
        private final float[] vector;
        @JsonProperty(value="top-k")
        private final int k;
        @JsonProperty(value="k-per-bucket")
        private final int kPerBucket;
        @JsonProperty(value="include-metadata")
        private final boolean includeMetadata;
        @JsonProperty(value="filter-query")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private final @Nullable String filterQuery;

        QueryRequest(float[] vector, int k, int kPerBucket, boolean includeMetadata) {
            this(vector, k, kPerBucket, includeMetadata, null);
        }

        QueryRequest(float[] vector, int k, int kPerBucket, boolean includeMetadata, @Nullable String filterQuery) {
            this.vector = vector;
            this.k = k;
            this.kPerBucket = kPerBucket;
            this.includeMetadata = includeMetadata;
            this.filterQuery = filterQuery;
        }

        public float[] getVector() {
            return this.vector;
        }

        public int getK() {
            return this.k;
        }

        public int getkPerBucket() {
            return this.kPerBucket;
        }

        public boolean isIncludeMetadata() {
            return this.includeMetadata;
        }

        public @Nullable String getFilterQuery() {
            return this.filterQuery;
        }
    }

    private static final class QueryResponse {
        private String key;
        private float score;
        private Map<String, Object> metadata;

        private QueryResponse() {
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setScore(float score) {
            this.score = score;
        }

        public void setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
        }
    }

    public static class CreateRequest {
        @JsonProperty(value="name")
        private final String indexName;
        @JsonProperty(value="beam-width")
        private final int beamWidth;
        @JsonProperty(value="max-connections")
        private final int maxConnections;
        @JsonProperty(value="vector-similarity-function")
        private final String vectorSimilarityFunction;
        @JsonProperty(value="fields")
        private final String[] fields;
        @JsonProperty(value="buckets")
        private final int buckets;

        public CreateRequest(String indexName, int beamWidth, int maxConnections, String vectorSimilarityFunction, String[] fields, int buckets) {
            this.indexName = indexName;
            this.beamWidth = beamWidth;
            this.maxConnections = maxConnections;
            this.vectorSimilarityFunction = vectorSimilarityFunction;
            this.fields = fields;
            this.buckets = buckets;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public int getBeamWidth() {
            return this.beamWidth;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public String getVectorSimilarityFunction() {
            return this.vectorSimilarityFunction;
        }

        public String[] getFields() {
            return this.fields;
        }

        public int getBuckets() {
            return this.buckets;
        }
    }

    private static class DeleteRequest {
        @JsonProperty(value="delete-data")
        private boolean deleteData = true;

        DeleteRequest() {
        }

        DeleteRequest(boolean deleteData) {
            this.deleteData = deleteData;
        }

        public boolean isDeleteData() {
            return this.deleteData;
        }

        public void setDeleteData(boolean deleteData) {
            this.deleteData = deleteData;
        }
    }
}

