/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.elevenlabs;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.audio.tts.Speech;
import org.springframework.ai.audio.tts.TextToSpeechModel;
import org.springframework.ai.audio.tts.TextToSpeechOptions;
import org.springframework.ai.audio.tts.TextToSpeechPrompt;
import org.springframework.ai.audio.tts.TextToSpeechResponse;
import org.springframework.ai.elevenlabs.ElevenLabsTextToSpeechOptions;
import org.springframework.ai.elevenlabs.api.ElevenLabsApi;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

public class ElevenLabsTextToSpeechModel
implements TextToSpeechModel {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ElevenLabsApi elevenLabsApi;
    private final RetryTemplate retryTemplate;
    private final ElevenLabsTextToSpeechOptions defaultOptions;

    public ElevenLabsTextToSpeechModel(ElevenLabsApi elevenLabsApi, ElevenLabsTextToSpeechOptions defaultOptions) {
        this(elevenLabsApi, defaultOptions, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public ElevenLabsTextToSpeechModel(ElevenLabsApi elevenLabsApi, ElevenLabsTextToSpeechOptions defaultOptions, RetryTemplate retryTemplate) {
        Assert.notNull((Object)elevenLabsApi, (String)"ElevenLabsApi must not be null");
        Assert.notNull((Object)defaultOptions, (String)"ElevenLabsSpeechOptions must not be null");
        Assert.notNull((Object)retryTemplate, (String)"RetryTemplate must not be null");
        this.elevenLabsApi = elevenLabsApi;
        this.defaultOptions = defaultOptions;
        this.retryTemplate = retryTemplate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TextToSpeechResponse call(TextToSpeechPrompt prompt) {
        RequestContext requestContext = this.prepareRequest(prompt);
        byte[] audioData = (byte[])this.retryTemplate.execute(context -> {
            ResponseEntity<byte[]> response = this.elevenLabsApi.textToSpeech(requestContext.request, requestContext.voiceId, requestContext.queryParameters);
            if (response.getBody() == null) {
                this.logger.warn("No speech response returned for request: {}", (Object)requestContext.request);
                return new byte[0];
            }
            return (byte[])response.getBody();
        });
        return new TextToSpeechResponse(List.of(new Speech(audioData)));
    }

    public Flux<TextToSpeechResponse> stream(TextToSpeechPrompt prompt) {
        RequestContext requestContext = this.prepareRequest(prompt);
        return (Flux)this.retryTemplate.execute(context -> this.elevenLabsApi.textToSpeechStream(requestContext.request, requestContext.voiceId, requestContext.queryParameters).map(entity -> new TextToSpeechResponse(List.of(new Speech((byte[])entity.getBody())))));
    }

    private RequestContext prepareRequest(TextToSpeechPrompt prompt) {
        ElevenLabsApi.SpeechRequest request = this.createRequest(prompt);
        ElevenLabsTextToSpeechOptions options = this.getOptions(prompt);
        String voiceId = options.getVoice();
        MultiValueMap<String, String> queryParameters = this.buildQueryParameters(options);
        return new RequestContext(request, voiceId, queryParameters);
    }

    private MultiValueMap<String, String> buildQueryParameters(ElevenLabsTextToSpeechOptions options) {
        LinkedMultiValueMap queryParameters = new LinkedMultiValueMap();
        if (options.getEnableLogging() != null) {
            queryParameters.add((Object)"enable_logging", (Object)options.getEnableLogging().toString());
        }
        if (options.getFormat() != null) {
            queryParameters.add((Object)"output_format", (Object)options.getFormat());
        }
        return queryParameters;
    }

    private ElevenLabsApi.SpeechRequest createRequest(TextToSpeechPrompt prompt) {
        ElevenLabsTextToSpeechOptions options = this.getOptions(prompt);
        String voiceId = options.getVoice();
        Assert.notNull((Object)voiceId, (String)"A voiceId must be specified in the ElevenLabsSpeechOptions.");
        String text = prompt.getInstructions().getText();
        Assert.hasText((String)text, (String)"Prompt must contain text to convert to speech.");
        return ElevenLabsApi.SpeechRequest.builder().text(text).modelId(options.getModelId()).voiceSettings(options.getVoiceSettings()).languageCode(options.getLanguageCode()).pronunciationDictionaryLocators(options.getPronunciationDictionaryLocators()).seed(options.getSeed()).previousText(options.getPreviousText()).nextText(options.getNextText()).previousRequestIds(options.getPreviousRequestIds()).nextRequestIds(options.getNextRequestIds()).applyTextNormalization(options.getApplyTextNormalization()).applyLanguageTextNormalization(options.getApplyLanguageTextNormalization()).build();
    }

    private ElevenLabsTextToSpeechOptions getOptions(TextToSpeechPrompt prompt) {
        ElevenLabsTextToSpeechOptions elevenLabsSpeechOptions;
        TextToSpeechOptions textToSpeechOptions = prompt.getOptions();
        ElevenLabsTextToSpeechOptions runtimeOptions = textToSpeechOptions instanceof ElevenLabsTextToSpeechOptions ? (elevenLabsSpeechOptions = (ElevenLabsTextToSpeechOptions)textToSpeechOptions) : null;
        return runtimeOptions != null ? this.merge(runtimeOptions, this.defaultOptions) : this.defaultOptions;
    }

    private ElevenLabsTextToSpeechOptions merge(ElevenLabsTextToSpeechOptions runtimeOptions, ElevenLabsTextToSpeechOptions defaultOptions) {
        return ElevenLabsTextToSpeechOptions.builder().modelId(this.getOrDefault(runtimeOptions.getModelId(), defaultOptions.getModelId())).voice(this.getOrDefault(runtimeOptions.getVoice(), defaultOptions.getVoice())).voiceId(this.getOrDefault(runtimeOptions.getVoiceId(), defaultOptions.getVoiceId())).format(this.getOrDefault(runtimeOptions.getFormat(), defaultOptions.getFormat())).outputFormat(this.getOrDefault(runtimeOptions.getOutputFormat(), defaultOptions.getOutputFormat())).voiceSettings(this.getOrDefault(runtimeOptions.getVoiceSettings(), defaultOptions.getVoiceSettings())).languageCode(this.getOrDefault(runtimeOptions.getLanguageCode(), defaultOptions.getLanguageCode())).pronunciationDictionaryLocators(this.getOrDefault(runtimeOptions.getPronunciationDictionaryLocators(), defaultOptions.getPronunciationDictionaryLocators())).seed(this.getOrDefault(runtimeOptions.getSeed(), defaultOptions.getSeed())).previousText(this.getOrDefault(runtimeOptions.getPreviousText(), defaultOptions.getPreviousText())).nextText(this.getOrDefault(runtimeOptions.getNextText(), defaultOptions.getNextText())).previousRequestIds(this.getOrDefault(runtimeOptions.getPreviousRequestIds(), defaultOptions.getPreviousRequestIds())).nextRequestIds(this.getOrDefault(runtimeOptions.getNextRequestIds(), defaultOptions.getNextRequestIds())).applyTextNormalization(this.getOrDefault(runtimeOptions.getApplyTextNormalization(), defaultOptions.getApplyTextNormalization())).applyLanguageTextNormalization(this.getOrDefault(runtimeOptions.getApplyLanguageTextNormalization(), defaultOptions.getApplyLanguageTextNormalization())).build();
    }

    private <T> T getOrDefault(T runtimeValue, T defaultValue) {
        return runtimeValue != null ? runtimeValue : defaultValue;
    }

    public ElevenLabsTextToSpeechOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public static final class Builder {
        private ElevenLabsApi elevenLabsApi;
        private RetryTemplate retryTemplate = RetryUtils.DEFAULT_RETRY_TEMPLATE;
        private ElevenLabsTextToSpeechOptions defaultOptions = ElevenLabsTextToSpeechOptions.builder().build();

        public Builder elevenLabsApi(ElevenLabsApi elevenLabsApi) {
            this.elevenLabsApi = elevenLabsApi;
            return this;
        }

        public Builder retryTemplate(RetryTemplate retryTemplate) {
            this.retryTemplate = retryTemplate;
            return this;
        }

        public Builder defaultOptions(ElevenLabsTextToSpeechOptions defaultOptions) {
            this.defaultOptions = defaultOptions;
            return this;
        }

        public ElevenLabsTextToSpeechModel build() {
            Assert.notNull((Object)this.elevenLabsApi, (String)"ElevenLabsApi must not be null");
            Assert.notNull((Object)this.defaultOptions, (String)"ElevenLabsSpeechOptions must not be null");
            return new ElevenLabsTextToSpeechModel(this.elevenLabsApi, this.defaultOptions, this.retryTemplate);
        }
    }

    private record RequestContext(ElevenLabsApi.SpeechRequest request, String voiceId, MultiValueMap<String, String> queryParameters) {
    }
}

