/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.elasticsearch;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;

public class ElasticsearchAiSearchFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    private static final Pattern DATE_FORMAT_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z");
    private final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(ZoneOffset.UTC);

    protected void doExpression(Filter.Expression expression, StringBuilder context) {
        if (expression.type() == Filter.ExpressionType.IN || expression.type() == Filter.ExpressionType.NIN) {
            context.append(this.getOperationSymbol(expression));
            context.append("(");
            this.convertOperand(expression.left(), context);
            this.convertOperand(expression.right(), context);
            context.append(")");
        } else if (expression.type() == Filter.ExpressionType.ISNULL) {
            context.append("-");
            this.convertOperand(expression.left(), context);
            context.append("*");
        } else if (expression.type() == Filter.ExpressionType.ISNOTNULL) {
            this.convertOperand(expression.left(), context);
            context.append("*");
        } else {
            this.convertOperand(expression.left(), context);
            context.append(this.getOperationSymbol(expression));
            this.convertOperand(expression.right(), context);
        }
    }

    protected void doStartValueRange(Filter.Value listValue, StringBuilder context) {
    }

    protected void doEndValueRange(Filter.Value listValue, StringBuilder context) {
    }

    protected void doAddValueRangeSpitter(Filter.Value listValue, StringBuilder context) {
        context.append(" OR ");
    }

    private String getOperationSymbol(Filter.Expression exp) {
        return switch (exp.type()) {
            case Filter.ExpressionType.AND -> " AND ";
            case Filter.ExpressionType.OR -> " OR ";
            case Filter.ExpressionType.EQ, Filter.ExpressionType.IN -> "";
            case Filter.ExpressionType.NE -> " NOT ";
            case Filter.ExpressionType.LT -> "<";
            case Filter.ExpressionType.LTE -> "<=";
            case Filter.ExpressionType.GT -> ">";
            case Filter.ExpressionType.GTE -> ">=";
            case Filter.ExpressionType.NIN -> "NOT ";
            default -> throw new RuntimeException("Not supported expression type: " + String.valueOf(exp.type()));
        };
    }

    public void doKey(Filter.Key key, StringBuilder context) {
        String identifier = this.hasOuterQuotes(key.key()) ? this.removeOuterQuotes(key.key()) : key.key();
        String prefixedIdentifier = this.withMetaPrefix(identifier);
        context.append(prefixedIdentifier.trim()).append(":");
    }

    public String withMetaPrefix(String identifier) {
        return "metadata." + identifier;
    }

    protected void doValue(Filter.Value filterValue, StringBuilder context) {
        Object object = filterValue.value();
        if (object instanceof List) {
            List list = (List)object;
            int c = 0;
            for (Object v : list) {
                context.append(v);
                if (c++ >= list.size() - 1) continue;
                this.doAddValueRangeSpitter(filterValue, context);
            }
        } else {
            this.doSingleValue(filterValue.value(), context);
        }
    }

    protected void doSingleValue(Object value, StringBuilder context) {
        if (value instanceof Date) {
            Date date = (Date)value;
            context.append(this.dateFormat.format(date.toInstant()));
        } else if (value instanceof String) {
            String text = (String)value;
            if (DATE_FORMAT_PATTERN.matcher(text).matches()) {
                try {
                    Instant date = Instant.from(this.dateFormat.parse(text));
                    context.append(this.dateFormat.format(date));
                }
                catch (DateTimeParseException e) {
                    throw new IllegalArgumentException("Invalid date type:" + text, e);
                }
            } else {
                context.append(text);
            }
        } else {
            context.append(value);
        }
    }

    public void doStartGroup(Filter.Group group, StringBuilder context) {
        context.append("(");
    }

    public void doEndGroup(Filter.Group group, StringBuilder context) {
        context.append(")");
    }
}

