/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore;

import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;

public class CouchbaseAiSearchFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    protected void doExpression(Filter.Expression expression, StringBuilder context) {
        this.convertOperand(expression.left(), context);
        context.append(this.getOperationSymbol(expression));
        this.convertOperand(expression.right(), context);
    }

    private String getOperationSymbol(Filter.Expression exp) {
        switch (exp.type()) {
            case AND: {
                return " AND ";
            }
            case OR: {
                return " OR ";
            }
            case EQ: {
                return " == ";
            }
            case NE: {
                return " != ";
            }
            case LT: {
                return " < ";
            }
            case LTE: {
                return " <= ";
            }
            case GT: {
                return " > ";
            }
            case GTE: {
                return " >= ";
            }
            case IN: {
                return " IN ";
            }
            case NIN: {
                return " NOT IN ";
            }
        }
        throw new RuntimeException("Not supported expression type: " + String.valueOf(exp.type()));
    }

    protected void doKey(Filter.Key key, StringBuilder context) {
        context.append("metadata.");
        context.append(key.key());
    }

    protected void doStartGroup(Filter.Group group, StringBuilder context) {
        context.append("(");
    }

    protected void doEndGroup(Filter.Group group, StringBuilder context) {
        context.append(")");
    }
}

