/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.document.id;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.springframework.ai.document.id.IdGenerator;
import org.springframework.util.Assert;

public class JdkSha256HexIdGenerator
implements IdGenerator {
    private static final String SHA_256 = "SHA-256";
    private final String byteHexFormat = "%02x";
    private final Charset charset;
    private final MessageDigest messageDigest;

    public JdkSha256HexIdGenerator(String algorithm, Charset charset) {
        this.charset = charset;
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public JdkSha256HexIdGenerator() {
        this(SHA_256, StandardCharsets.UTF_8);
    }

    @Override
    public String generateId(Object ... contents) {
        return this.hash(this.serializeToBytes(contents));
    }

    private String hash(byte[] contentWithMetadata) {
        byte[] hashBytes = this.getMessageDigest().digest(contentWithMetadata);
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(String.format(this.byteHexFormat, b));
        }
        return UUID.nameUUIDFromBytes(sb.toString().getBytes(this.charset)).toString();
    }

    private byte[] serializeToBytes(Object ... contents) {
        byte[] throwable2;
        Assert.notNull((Object)contents, (String)"Contents must not be null");
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            for (Object content : contents) {
                out.writeObject(content);
            }
            throwable2 = byteOut.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteOut.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to serialize", e);
            }
        }
        byteOut.close();
        return throwable2;
    }

    MessageDigest getMessageDigest() {
        try {
            return (MessageDigest)this.messageDigest.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Unsupported clone for MessageDigest.", e);
        }
    }
}

