/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.coherence;

import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.UniversalExtractor;
import java.util.List;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterHelper;
import org.springframework.util.Assert;

public class CoherenceFilterExpressionConverter {
    public Filter<?> convert(Filter.Operand expression) {
        if (expression instanceof Filter.Expression) {
            return this.convert((Filter.Expression)expression);
        }
        return this.convert((Filter.Group)expression);
    }

    private Filter<?> convert(Filter.Group group) {
        return this.convert(group.content());
    }

    private Filter<?> convert(Filter.Expression expression) {
        if (expression.type() == Filter.ExpressionType.NOT) {
            return this.convert(FilterHelper.negate((Filter.Operand)expression));
        }
        Assert.state((expression.right() != null ? 1 : 0) != 0, (String)"expression is expected to have a right operand");
        return switch (expression.type()) {
            case Filter.ExpressionType.EQ -> Filters.equal((ValueExtractor)this.extractor(expression.left()), this.value(expression.right()));
            case Filter.ExpressionType.NE -> Filters.notEqual((ValueExtractor)this.extractor(expression.left()), this.value(expression.right()));
            case Filter.ExpressionType.GT -> Filters.greater((ValueExtractor)this.extractor(expression.left()), (Comparable)((Comparable)this.value(expression.right())));
            case Filter.ExpressionType.GTE -> Filters.greaterEqual((ValueExtractor)this.extractor(expression.left()), (Comparable)((Comparable)this.value(expression.right())));
            case Filter.ExpressionType.LT -> Filters.less((ValueExtractor)this.extractor(expression.left()), (Comparable)((Comparable)this.value(expression.right())));
            case Filter.ExpressionType.LTE -> Filters.lessEqual((ValueExtractor)this.extractor(expression.left()), (Comparable)((Comparable)this.value(expression.right())));
            case Filter.ExpressionType.IN -> Filters.in((ValueExtractor)this.extractor(expression.left()), (Object[])((List)this.value(expression.right())).toArray());
            case Filter.ExpressionType.NIN -> Filters.not((Filter)Filters.in((ValueExtractor)this.extractor(expression.left()), (Object[])((List)this.value(expression.right())).toArray()));
            case Filter.ExpressionType.AND -> Filters.all((Filter[])new Filter[]{this.convert(expression.left()), this.convert(expression.right())});
            case Filter.ExpressionType.OR -> Filters.any((Filter[])new Filter[]{this.convert(expression.left()), this.convert(expression.right())});
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(expression.type()));
        };
    }

    private ValueExtractor extractor(Filter.Operand op) {
        return new ChainedExtractor((ValueExtractor)new UniversalExtractor("metadata"), (ValueExtractor)new UniversalExtractor(((Filter.Key)op).key()));
    }

    private <T> T value(Filter.Operand op) {
        return (T)((Filter.Value)op).value();
    }
}

