/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.DefaultChatClient;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.DefaultChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.tool.DefaultToolCallingChatOptions;
import org.springframework.ai.model.tool.ToolCallingChatOptions;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

final class DefaultChatClientUtils {
    private DefaultChatClientUtils() {
    }

    static ChatClientRequest toChatClientRequest(DefaultChatClient.DefaultChatClientRequestSpec inputRequest) {
        String processedUserText;
        Assert.notNull((Object)inputRequest, (String)"inputRequest cannot be null");
        ArrayList<Object> processedMessages = new ArrayList<Object>();
        String processedSystemText = inputRequest.getSystemText();
        if (StringUtils.hasText((String)processedSystemText)) {
            if (!CollectionUtils.isEmpty(inputRequest.getSystemParams())) {
                processedSystemText = PromptTemplate.builder().template(processedSystemText).variables(inputRequest.getSystemParams()).renderer(inputRequest.getTemplateRenderer()).build().render();
            }
            processedMessages.add(SystemMessage.builder().text(processedSystemText).metadata(inputRequest.getSystemMetadata()).build());
        }
        if (!CollectionUtils.isEmpty(inputRequest.getMessages())) {
            processedMessages.addAll(inputRequest.getMessages());
        }
        if (StringUtils.hasText((String)(processedUserText = inputRequest.getUserText()))) {
            if (!CollectionUtils.isEmpty(inputRequest.getUserParams())) {
                processedUserText = PromptTemplate.builder().template(processedUserText).variables(inputRequest.getUserParams()).renderer(inputRequest.getTemplateRenderer()).build().render();
            }
            processedMessages.add(UserMessage.builder().text(processedUserText).media(inputRequest.getMedia()).metadata(inputRequest.getUserMetadata()).build());
        }
        ChatOptions processedChatOptions = inputRequest.getChatOptions();
        if (!(inputRequest.getToolNames().isEmpty() && inputRequest.getToolCallbacks().isEmpty() && inputRequest.getToolCallbackProviders().isEmpty() && CollectionUtils.isEmpty(inputRequest.getToolContext()))) {
            if (processedChatOptions == null) {
                processedChatOptions = new DefaultToolCallingChatOptions();
            } else if (processedChatOptions instanceof DefaultChatOptions) {
                DefaultChatOptions defaultChatOptions = (DefaultChatOptions)processedChatOptions;
                processedChatOptions = (ChatOptions)ModelOptionsUtils.copyToTarget((Object)defaultChatOptions, ChatOptions.class, DefaultToolCallingChatOptions.class);
            }
        }
        if (processedChatOptions instanceof ToolCallingChatOptions) {
            ToolCallingChatOptions toolCallingChatOptions = (ToolCallingChatOptions)processedChatOptions;
            if (!inputRequest.getToolNames().isEmpty()) {
                Set toolNames = ToolCallingChatOptions.mergeToolNames(new HashSet<String>(inputRequest.getToolNames()), (Set)toolCallingChatOptions.getToolNames());
                toolCallingChatOptions.setToolNames(toolNames);
            }
            ArrayList<ToolCallback> allToolCallbacks = new ArrayList<ToolCallback>(inputRequest.getToolCallbacks());
            for (ToolCallbackProvider provider : inputRequest.getToolCallbackProviders()) {
                allToolCallbacks.addAll(List.of(provider.getToolCallbacks()));
            }
            if (!allToolCallbacks.isEmpty()) {
                List toolCallbacks = ToolCallingChatOptions.mergeToolCallbacks(allToolCallbacks, (List)toolCallingChatOptions.getToolCallbacks());
                ToolCallingChatOptions.validateToolCallbacks((List)toolCallbacks);
                toolCallingChatOptions.setToolCallbacks(toolCallbacks);
            }
            if (!CollectionUtils.isEmpty(inputRequest.getToolContext())) {
                Map toolContext = ToolCallingChatOptions.mergeToolContext(inputRequest.getToolContext(), (Map)toolCallingChatOptions.getToolContext());
                toolCallingChatOptions.setToolContext(toolContext);
            }
        }
        Prompt.Builder promptBuilder = Prompt.builder().messages(processedMessages);
        if (processedChatOptions != null) {
            promptBuilder.chatOptions(processedChatOptions);
        }
        return ChatClientRequest.builder().prompt(promptBuilder.build()).context(new ConcurrentHashMap<String, Object>(inputRequest.getAdvisorParams())).build();
    }
}

