/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client;

import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.util.Assert;

public record ChatClientResponse(@Nullable ChatResponse chatResponse, Map<String, @Nullable Object> context) {
    public ChatClientResponse(@Nullable ChatResponse chatResponse, Map<String, Object> context) {
        Assert.notNull(context, (String)"context cannot be null");
        Assert.noNullElements(context.keySet(), (String)"context keys cannot be null");
    }

    public ChatClientResponse copy() {
        return new ChatClientResponse(this.chatResponse, new HashMap<String, Object>(this.context));
    }

    public Builder mutate() {
        return new Builder().chatResponse(this.chatResponse).context(new HashMap<String, Object>(this.context));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private @Nullable ChatResponse chatResponse;
        private final Map<String, @Nullable Object> context = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder chatResponse(@Nullable ChatResponse chatResponse) {
            this.chatResponse = chatResponse;
            return this;
        }

        public Builder context(Map<String, ? extends @Nullable Object> context) {
            Assert.notNull(context, (String)"context cannot be null");
            this.context.putAll(context);
            return this;
        }

        public Builder context(String key, Object value) {
            Assert.notNull((Object)key, (String)"key cannot be null");
            this.context.put(key, value);
            return this;
        }

        public ChatClientResponse build() {
            return new ChatClientResponse(this.chatResponse, this.context);
        }
    }
}

