/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor;

import java.util.Map;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.api.StreamAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisorChain;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public final class ChatModelStreamAdvisor
implements StreamAdvisor {
    private final ChatModel chatModel;

    private ChatModelStreamAdvisor(ChatModel chatModel) {
        Assert.notNull((Object)chatModel, (String)"chatModel cannot be null");
        this.chatModel = chatModel;
    }

    @Override
    public Flux<ChatClientResponse> adviseStream(ChatClientRequest chatClientRequest, StreamAroundAdvisorChain chain) {
        Assert.notNull((Object)chatClientRequest, (String)"the chatClientRequest cannot be null");
        return this.chatModel.stream(chatClientRequest.prompt()).map(chatResponse -> ChatClientResponse.builder().chatResponse((ChatResponse)chatResponse).context(Map.copyOf(chatClientRequest.context())).build()).publishOn(Schedulers.boundedElastic());
    }

    @Override
    public String getName() {
        return "stream";
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ChatModel chatModel;

        private Builder() {
        }

        public Builder chatModel(ChatModel chatModel) {
            this.chatModel = chatModel;
            return this;
        }

        public ChatModelStreamAdvisor build() {
            return new ChatModelStreamAdvisor(this.chatModel);
        }
    }
}

