/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor;

import java.util.Map;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.api.CallAdvisor;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisorChain;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.util.Assert;

public final class ChatModelCallAdvisor
implements CallAdvisor {
    private final ChatModel chatModel;

    private ChatModelCallAdvisor(ChatModel chatModel) {
        Assert.notNull((Object)chatModel, (String)"chatModel cannot be null");
        this.chatModel = chatModel;
    }

    @Override
    public ChatClientResponse adviseCall(ChatClientRequest chatClientRequest, CallAroundAdvisorChain chain) {
        Assert.notNull((Object)chatClientRequest, (String)"the chatClientRequest cannot be null");
        ChatResponse chatResponse = this.chatModel.call(chatClientRequest.prompt());
        return ChatClientResponse.builder().chatResponse(chatResponse).context(Map.copyOf(chatClientRequest.context())).build();
    }

    @Override
    public String getName() {
        return "call";
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ChatModel chatModel;

        private Builder() {
        }

        public Builder chatModel(ChatModel chatModel) {
            this.chatModel = chatModel;
            return this;
        }

        public ChatModelCallAdvisor build() {
            return new ChatModelCallAdvisor(this.chatModel);
        }
    }
}

