/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.cassandra;

import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;

class CassandraFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    private final Map<String, ColumnMetadata> columnsByName;

    CassandraFilterExpressionConverter(Collection<ColumnMetadata> columns) {
        this.columnsByName = columns.stream().collect(Collectors.toMap(c -> c.getName().asInternal(), Function.identity()));
    }

    private static void doOperand(Filter.ExpressionType type, StringBuilder context) {
        switch (type) {
            case EQ: {
                context.append(" = ");
                break;
            }
            case NE: {
                context.append(" != ");
                break;
            }
            case GT: {
                context.append(" > ");
                break;
            }
            case GTE: {
                context.append(" >= ");
                break;
            }
            case IN: {
                context.append(" IN ");
                break;
            }
            case LT: {
                context.append(" < ");
                break;
            }
            case LTE: {
                context.append(" <= ");
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Expression type %s not yet implemented. Patches welcome.", type));
            }
        }
    }

    protected void doKey(Filter.Key key, StringBuilder context) {
        String keyName = key.key();
        Optional<ColumnMetadata> column = this.getColumn(keyName);
        Preconditions.checkArgument((boolean)column.isPresent(), (String)"No metafield %s has been configured", (Object)keyName);
        context.append(column.get().getName().asCql(false));
    }

    protected void doExpression(Filter.Expression expression, StringBuilder context) {
        switch (expression.type()) {
            case AND: {
                this.doBinaryOperation(" and ", expression, context);
                break;
            }
            case OR: {
                this.doBinaryOperation(" or ", expression, context);
                break;
            }
            case NIN: 
            case NOT: {
                throw new UnsupportedOperationException(String.format("Expression type %s not yet implemented. Patches welcome.", expression.type()));
            }
            default: {
                this.doField(expression, context);
            }
        }
    }

    private void doBinaryOperation(String operator, Filter.Expression expression, StringBuilder context) {
        this.convertOperand(expression.left(), context);
        context.append(operator);
        this.convertOperand(expression.right(), context);
    }

    private void doField(Filter.Expression expression, StringBuilder context) {
        this.doKey((Filter.Key)expression.left(), context);
        CassandraFilterExpressionConverter.doOperand(expression.type(), context);
        ColumnMetadata column = this.getColumn(((Filter.Key)expression.left()).key()).get();
        Object v = ((Filter.Value)expression.right()).value();
        if (Filter.ExpressionType.IN.equals((Object)expression.type())) {
            Preconditions.checkArgument((boolean)(v instanceof Collection));
            this.doListValue(column, v, context);
        } else {
            this.doValue(column, v, context);
        }
    }

    private void doListValue(ColumnMetadata column, Object v, StringBuilder context) {
        context.append('(');
        for (Object e : (Collection)v) {
            this.doValue(column, e, context);
            context.append(',');
        }
        context.deleteCharAt(context.length() - 1);
        context.append(')');
    }

    private void doValue(ColumnMetadata column, Object v, StringBuilder context) {
        DataType dataType = column.getType();
        if (dataType instanceof ListType && !(v instanceof Collection)) {
            dataType = ((ListType)dataType).getElementType();
        }
        if (DataTypes.SMALLINT.equals((Object)column.getType())) {
            v = ((Number)v).shortValue();
        }
        context.append(CodecRegistry.DEFAULT.codecFor(dataType).format(v));
    }

    private Optional<ColumnMetadata> getColumn(String name) {
        Optional<ColumnMetadata> column = Optional.ofNullable(this.columnsByName.get(name));
        if (column.isEmpty() && name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
            column = Optional.ofNullable(this.columnsByName.get(name));
        }
        return column;
    }
}

