/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.aot;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class BedrockRuntimeHints
implements RuntimeHintsRegistrar {
    private final String rootPackage = "software.amazon.awssdk";
    private final Logger log = LoggerFactory.getLogger(BedrockRuntimeHints.class);
    private final MemberCategory[] memberCategories = MemberCategory.values();
    private final Collection<TypeReference> allClasses;
    private final PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    BedrockRuntimeHints() {
        this.allClasses = this.find(this.rootPackage);
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        try {
            this.registerBedrockRuntimeService(hints);
            this.registerSerializationClasses(hints);
            this.registerResources(hints);
        }
        catch (Throwable ex) {
            this.log.warn("error when registering Bedrock types", ex);
        }
    }

    private void registerBedrockRuntimeService(RuntimeHints hints) {
        String pkg = this.rootPackage + ".services.bedrockruntime";
        HashSet<TypeReference> all = new HashSet<TypeReference>();
        for (TypeReference clzz : this.allClasses) {
            if (!clzz.getName().contains("Bedrock") || !clzz.getName().contains("Client")) continue;
            all.add(clzz);
        }
        String modelPkg = pkg + ".model";
        all.addAll(this.find(modelPkg));
        all.forEach(tr -> hints.reflection().registerType(tr, this.memberCategories));
    }

    private void registerSerializationClasses(RuntimeHints hints) {
        for (TypeReference c : this.allClasses) {
            try {
                Class serializableClass = ClassUtils.forName((String)c.getName(), (ClassLoader)this.getClass().getClassLoader());
                if (!Serializable.class.isAssignableFrom(serializableClass)) continue;
                hints.reflection().registerType(serializableClass, this.memberCategories);
                hints.serialization().registerType(c);
            }
            catch (Throwable throwable) {}
        }
    }

    private void registerResources(RuntimeHints hints) throws Exception {
        for (Resource resource : this.resolver.getResources("classpath*:software/amazon/awssdk/**/*.interceptors")) {
            hints.resources().registerResource(resource);
        }
        for (Resource resource : this.resolver.getResources("classpath*:software/amazon/awssdk/**/*.json")) {
            hints.resources().registerResource(resource);
        }
    }

    protected List<TypeReference> find(String packageName) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false){

            protected boolean isCandidateComponent(MetadataReader metadataReader) throws IOException {
                return true;
            }

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                return true;
            }
        };
        return scanner.findCandidateComponents(packageName).stream().map(BeanDefinition::getBeanClassName).filter(Objects::nonNull).filter(x -> !x.contains("package-info")).map(TypeReference::of).toList();
    }
}

