/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.titan.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Map;
import org.springframework.ai.bedrock.api.AbstractBedrockApi;
import org.springframework.util.Assert;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class TitanEmbeddingBedrockApi
extends AbstractBedrockApi<TitanEmbeddingRequest, TitanEmbeddingResponse, TitanEmbeddingResponse> {
    public TitanEmbeddingBedrockApi(String modelId, String region, Duration timeout) {
        super(modelId, region, timeout);
    }

    public TitanEmbeddingBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    public TitanEmbeddingBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, Region region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    @Override
    public TitanEmbeddingResponse embedding(TitanEmbeddingRequest request) {
        return this.internalInvocation(request, TitanEmbeddingResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record TitanEmbeddingResponse(@JsonProperty(value="embedding") float[] embedding, @JsonProperty(value="inputTextTokenCount") Integer inputTextTokenCount, @JsonProperty(value="successCount") Integer successCount, @JsonProperty(value="failureCount") Integer failureCount, @JsonProperty(value="embeddingsByType") Map<String, Object> embeddingsByType, @JsonProperty(value="results") Object results, @JsonProperty(value="message") Object message) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record TitanEmbeddingRequest(@JsonProperty(value="inputText") String inputText, @JsonProperty(value="inputImage") String inputImage) {
        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String inputText;
            private String inputImage;

            public Builder inputText(String inputText) {
                this.inputText = inputText;
                return this;
            }

            public Builder inputImage(String inputImage) {
                this.inputImage = inputImage;
                return this;
            }

            public TitanEmbeddingRequest build() {
                Assert.isTrue((this.inputText != null || this.inputImage != null ? 1 : 0) != 0, (String)"At least one of the inputText or inputImage parameters must be provided!");
                Assert.isTrue((this.inputText == null || this.inputImage == null ? 1 : 0) != 0, (String)"Only one of the inputText or inputImage parameters must be provided!");
                return new TitanEmbeddingRequest(this.inputText, this.inputImage);
            }
        }
    }

    public static enum TitanEmbeddingModel {
        TITAN_EMBED_IMAGE_V1("amazon.titan-embed-image-v1"),
        TITAN_EMBED_TEXT_V1("amazon.titan-embed-text-v1"),
        TITAN_EMBED_TEXT_V2("amazon.titan-embed-text-v2:0");

        private final String id;

        private TitanEmbeddingModel(String value) {
            this.id = value;
        }

        public String id() {
            return this.id;
        }
    }
}

