/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.titan;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.bedrock.titan.BedrockTitanEmbeddingOptions;
import org.springframework.ai.bedrock.titan.api.TitanEmbeddingBedrockApi;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.util.Assert;

public class BedrockTitanEmbeddingModel
extends AbstractEmbeddingModel {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final TitanEmbeddingBedrockApi embeddingApi;
    private final ObservationRegistry observationRegistry;
    private InputType inputType = InputType.TEXT;

    public BedrockTitanEmbeddingModel(TitanEmbeddingBedrockApi titanEmbeddingBedrockApi, ObservationRegistry observationRegistry) {
        this.embeddingApi = titanEmbeddingBedrockApi;
        this.observationRegistry = observationRegistry;
    }

    public BedrockTitanEmbeddingModel withInputType(InputType inputType) {
        this.inputType = inputType;
        return this;
    }

    public float[] embed(Document document) {
        return this.embed(document.getText());
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        Assert.notEmpty((Collection)request.getInstructions(), (String)"At least one text is required!");
        if (request.getInstructions().size() != 1) {
            this.logger.warn("Titan Embedding does not support batch embedding. Multiple API calls will be made.");
        }
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        AtomicInteger indexCounter = new AtomicInteger(0);
        int tokenUsage = 0;
        for (String inputContent : request.getInstructions()) {
            TitanEmbeddingBedrockApi.TitanEmbeddingRequest apiRequest = this.createTitanEmbeddingRequest(inputContent, request.getOptions());
            try {
                TitanEmbeddingBedrockApi.TitanEmbeddingResponse response = (TitanEmbeddingBedrockApi.TitanEmbeddingResponse)Observation.createNotStarted((String)"bedrock.embedding", (ObservationRegistry)this.observationRegistry).lowCardinalityKeyValue("model", "titan").lowCardinalityKeyValue("input_type", this.inputType.name().toLowerCase()).highCardinalityKeyValue("input_length", String.valueOf(inputContent.length())).observe(() -> {
                    TitanEmbeddingBedrockApi.TitanEmbeddingResponse r = this.embeddingApi.embedding(apiRequest);
                    Assert.notNull((Object)r, (String)"Embedding API returned null response");
                    return r;
                });
                if (response.embedding() == null || response.embedding().length == 0) {
                    this.logger.warn("Empty embedding vector returned for input at index {}. Skipping.", (Object)indexCounter.get());
                    continue;
                }
                embeddings.add(new Embedding(response.embedding(), Integer.valueOf(indexCounter.getAndIncrement())));
                if (response.inputTextTokenCount() == null) continue;
                tokenUsage += response.inputTextTokenCount().intValue();
            }
            catch (Exception ex) {
                this.logger.error("Titan API embedding failed for input at index {}: {}", new Object[]{indexCounter.get(), this.summarizeInput(inputContent), ex});
                throw ex;
            }
        }
        EmbeddingResponseMetadata embeddingResponseMetadata = new EmbeddingResponseMetadata("", (Usage)this.getDefaultUsage(tokenUsage));
        return new EmbeddingResponse(embeddings, embeddingResponseMetadata);
    }

    private TitanEmbeddingBedrockApi.TitanEmbeddingRequest createTitanEmbeddingRequest(String inputContent, EmbeddingOptions requestOptions) {
        InputType inputType = this.inputType;
        if (requestOptions != null && requestOptions instanceof BedrockTitanEmbeddingOptions) {
            BedrockTitanEmbeddingOptions bedrockTitanEmbeddingOptions = (BedrockTitanEmbeddingOptions)requestOptions;
            inputType = bedrockTitanEmbeddingOptions.getInputType();
        }
        return inputType == InputType.IMAGE ? new TitanEmbeddingBedrockApi.TitanEmbeddingRequest.Builder().inputImage(inputContent).build() : new TitanEmbeddingBedrockApi.TitanEmbeddingRequest.Builder().inputText(inputContent).build();
    }

    public int dimensions() {
        if (this.inputType == InputType.IMAGE && this.embeddingDimensions.get() < 0) {
            this.embeddingDimensions.set(BedrockTitanEmbeddingModel.dimensions((EmbeddingModel)this, (String)this.embeddingApi.getModelId(), (String)"iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNk+A8AAQUBAScY42YAAAAASUVORK5CYII="));
        }
        return super.dimensions();
    }

    private String summarizeInput(String input) {
        if (this.inputType == InputType.IMAGE) {
            return "[image content omitted, length=" + input.length() + "]";
        }
        return input.length() > 100 ? input.substring(0, 100) + "..." : input;
    }

    private DefaultUsage getDefaultUsage(int tokens) {
        return new DefaultUsage(Integer.valueOf(tokens), Integer.valueOf(0));
    }

    public static enum InputType {
        TEXT,
        IMAGE;

    }
}

