/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.cohere;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.ai.bedrock.cohere.BedrockCohereEmbeddingOptions;
import org.springframework.ai.bedrock.cohere.api.CohereEmbeddingBedrockApi;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.util.Assert;

public class BedrockCohereEmbeddingModel
extends AbstractEmbeddingModel {
    private static final int COHERE_MAX_CHARACTERS = 2048;
    private final CohereEmbeddingBedrockApi embeddingApi;
    private final BedrockCohereEmbeddingOptions defaultOptions;

    public BedrockCohereEmbeddingModel(CohereEmbeddingBedrockApi cohereEmbeddingBedrockApi) {
        this(cohereEmbeddingBedrockApi, BedrockCohereEmbeddingOptions.builder().inputType(CohereEmbeddingBedrockApi.CohereEmbeddingRequest.InputType.SEARCH_DOCUMENT).truncate(CohereEmbeddingBedrockApi.CohereEmbeddingRequest.Truncate.NONE).build());
    }

    public BedrockCohereEmbeddingModel(CohereEmbeddingBedrockApi cohereEmbeddingBedrockApi, BedrockCohereEmbeddingOptions options) {
        Assert.notNull((Object)cohereEmbeddingBedrockApi, (String)"CohereEmbeddingBedrockApi must not be null");
        Assert.notNull((Object)options, (String)"BedrockCohereEmbeddingOptions must not be null");
        this.embeddingApi = cohereEmbeddingBedrockApi;
        this.defaultOptions = options;
    }

    public float[] embed(Document document) {
        return this.embed(document.getText());
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        List instructions = request.getInstructions();
        Assert.notEmpty((Collection)instructions, (String)"At least one text is required!");
        BedrockCohereEmbeddingOptions optionsToUse = this.mergeOptions(request.getOptions());
        List<String> truncatedInstructions = instructions.stream().map(text -> {
            if (text == null || text.isEmpty()) {
                return text;
            }
            if (text.length() <= 2048) {
                return text;
            }
            return switch (optionsToUse.getTruncate()) {
                case CohereEmbeddingBedrockApi.CohereEmbeddingRequest.Truncate.END -> text.substring(0, 2048);
                case CohereEmbeddingBedrockApi.CohereEmbeddingRequest.Truncate.START -> text.substring(text.length() - 2048);
                default -> text.substring(0, 2048);
            };
        }).collect(Collectors.toList());
        CohereEmbeddingBedrockApi.CohereEmbeddingRequest apiRequest = new CohereEmbeddingBedrockApi.CohereEmbeddingRequest(truncatedInstructions, optionsToUse.getInputType(), optionsToUse.getTruncate());
        CohereEmbeddingBedrockApi.CohereEmbeddingResponse apiResponse = this.embeddingApi.embedding(apiRequest);
        AtomicInteger indexCounter = new AtomicInteger(0);
        List<Embedding> embeddings = apiResponse.embeddings().stream().map(e -> new Embedding(e, Integer.valueOf(indexCounter.getAndIncrement()))).toList();
        return new EmbeddingResponse(embeddings);
    }

    BedrockCohereEmbeddingOptions mergeOptions(EmbeddingOptions requestOptions) {
        BedrockCohereEmbeddingOptions options;
        BedrockCohereEmbeddingOptions bedrockCohereEmbeddingOptions = options = this.defaultOptions != null ? this.defaultOptions : BedrockCohereEmbeddingOptions.builder().inputType(CohereEmbeddingBedrockApi.CohereEmbeddingRequest.InputType.SEARCH_DOCUMENT).truncate(CohereEmbeddingBedrockApi.CohereEmbeddingRequest.Truncate.NONE).build();
        if (requestOptions != null) {
            options = (BedrockCohereEmbeddingOptions)ModelOptionsUtils.merge((Object)requestOptions, (Object)options, BedrockCohereEmbeddingOptions.class);
        }
        return options;
    }
}

