/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.cohere.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.List;
import org.springframework.ai.bedrock.api.AbstractBedrockApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class CohereEmbeddingBedrockApi
extends AbstractBedrockApi<CohereEmbeddingRequest, CohereEmbeddingResponse, CohereEmbeddingResponse> {
    public CohereEmbeddingBedrockApi(String modelId, String region) {
        super(modelId, region);
    }

    public CohereEmbeddingBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper) {
        super(modelId, credentialsProvider, region, objectMapper);
    }

    public CohereEmbeddingBedrockApi(String modelId, String region, Duration timeout) {
        super(modelId, region, timeout);
    }

    public CohereEmbeddingBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    public CohereEmbeddingBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, Region region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    @Override
    public CohereEmbeddingResponse embedding(CohereEmbeddingRequest request) {
        return this.internalInvocation(request, CohereEmbeddingResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public record CohereEmbeddingResponse(@JsonProperty(value="id") String id, @JsonProperty(value="embeddings") List<float[]> embeddings, @JsonProperty(value="texts") List<String> texts, @JsonProperty(value="response_type") String responseType, @JsonProperty(value="amazon-bedrock-invocationMetrics") AbstractBedrockApi.AmazonBedrockInvocationMetrics amazonBedrockInvocationMetrics) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record CohereEmbeddingRequest(@JsonProperty(value="texts") List<String> texts, @JsonProperty(value="input_type") InputType inputType, @JsonProperty(value="truncate") Truncate truncate) {

        public static enum InputType {
            SEARCH_DOCUMENT,
            SEARCH_QUERY,
            CLASSIFICATION,
            CLUSTERING;

        }

        public static enum Truncate {
            NONE,
            START,
            END;

        }
    }

    public static enum CohereEmbeddingModel {
        COHERE_EMBED_MULTILINGUAL_V3("cohere.embed-multilingual-v3"),
        COHERE_EMBED_ENGLISH_V3("cohere.embed-english-v3");

        private final String id;

        private CohereEmbeddingModel(String value) {
            this.id = value;
        }

        public String id() {
            return this.id;
        }
    }
}

