/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.cohere;

import java.util.List;
import org.springframework.ai.bedrock.BedrockUsage;
import org.springframework.ai.bedrock.MessageToPromptConverter;
import org.springframework.ai.bedrock.cohere.BedrockCohereChatOptions;
import org.springframework.ai.bedrock.cohere.api.CohereChatBedrockApi;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.StreamingChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class BedrockCohereChatModel
implements ChatModel,
StreamingChatModel {
    private final CohereChatBedrockApi chatApi;
    private final BedrockCohereChatOptions defaultOptions;

    public BedrockCohereChatModel(CohereChatBedrockApi chatApi) {
        this(chatApi, BedrockCohereChatOptions.builder().build());
    }

    public BedrockCohereChatModel(CohereChatBedrockApi chatApi, BedrockCohereChatOptions options) {
        Assert.notNull((Object)chatApi, (String)"CohereChatBedrockApi must not be null");
        Assert.notNull((Object)options, (String)"BedrockCohereChatOptions must not be null");
        this.chatApi = chatApi;
        this.defaultOptions = options;
    }

    public ChatResponse call(Prompt prompt) {
        CohereChatBedrockApi.CohereChatResponse response = this.chatApi.chatCompletion(this.createRequest(prompt, false));
        List<Generation> generations = response.generations().stream().map(g -> new Generation(g.text())).toList();
        return new ChatResponse(generations);
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        return this.chatApi.chatCompletionStream(this.createRequest(prompt, true)).map(g -> {
            if (g.isFinished().booleanValue()) {
                String finishReason = g.finishReason().name();
                BedrockUsage usage = BedrockUsage.from(g.amazonBedrockInvocationMetrics());
                return new ChatResponse(List.of(new Generation("").withGenerationMetadata(ChatGenerationMetadata.from((String)finishReason, (Object)usage))));
            }
            return new ChatResponse(List.of(new Generation(g.text())));
        });
    }

    CohereChatBedrockApi.CohereChatRequest createRequest(Prompt prompt, boolean stream) {
        String promptValue = MessageToPromptConverter.create().toPrompt(prompt.getInstructions());
        CohereChatBedrockApi.CohereChatRequest request = CohereChatBedrockApi.CohereChatRequest.builder(promptValue).withTemperature(this.defaultOptions.getTemperature()).withTopP(this.defaultOptions.getTopP()).withTopK(this.defaultOptions.getTopK()).withMaxTokens(this.defaultOptions.getMaxTokens()).withStopSequences(this.defaultOptions.getStopSequences()).withReturnLikelihoods(this.defaultOptions.getReturnLikelihoods()).withStream(stream).withNumGenerations(this.defaultOptions.getNumGenerations()).withLogitBias(this.defaultOptions.getLogitBias()).withTruncate(this.defaultOptions.getTruncate()).build();
        if (prompt.getOptions() != null) {
            BedrockCohereChatOptions updatedRuntimeOptions = (BedrockCohereChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, BedrockCohereChatOptions.class);
            request = (CohereChatBedrockApi.CohereChatRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, CohereChatBedrockApi.CohereChatRequest.class);
        }
        return request;
    }

    public ChatOptions getDefaultOptions() {
        return BedrockCohereChatOptions.fromOptions(this.defaultOptions);
    }
}

