/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.anthropic3.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.List;
import org.springframework.ai.bedrock.api.AbstractBedrockApi;
import org.springframework.ai.model.ChatModelDescription;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class Anthropic3ChatBedrockApi
extends AbstractBedrockApi<AnthropicChatRequest, AnthropicChatResponse, AnthropicChatStreamingResponse> {
    public static final String DEFAULT_ANTHROPIC_VERSION = "bedrock-2023-05-31";

    public Anthropic3ChatBedrockApi(String modelId, String region) {
        super(modelId, region);
    }

    public Anthropic3ChatBedrockApi(String modelId, String region, Duration timeout) {
        super(modelId, region, timeout);
    }

    public Anthropic3ChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper) {
        super(modelId, credentialsProvider, region, objectMapper);
    }

    public Anthropic3ChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, String region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    public Anthropic3ChatBedrockApi(String modelId, AwsCredentialsProvider credentialsProvider, Region region, ObjectMapper objectMapper, Duration timeout) {
        super(modelId, credentialsProvider, region, objectMapper, timeout);
    }

    @Override
    public AnthropicChatResponse chatCompletion(AnthropicChatRequest anthropicRequest) {
        Assert.notNull((Object)anthropicRequest, (String)"'anthropicRequest' must not be null");
        return this.internalInvocation(anthropicRequest, AnthropicChatResponse.class);
    }

    @Override
    public Flux<AnthropicChatStreamingResponse> chatCompletionStream(AnthropicChatRequest anthropicRequest) {
        Assert.notNull((Object)anthropicRequest, (String)"'anthropicRequest' must not be null");
        return this.internalInvocationStream(anthropicRequest, AnthropicChatStreamingResponse.class);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record AnthropicChatResponse(@JsonProperty(value="id") String id, @JsonProperty(value="model") String model, @JsonProperty(value="type") String type, @JsonProperty(value="role") String role, @JsonProperty(value="content") List<MediaContent> content, @JsonProperty(value="stop_reason") String stopReason, @JsonProperty(value="stop_sequence") String stopSequence, @JsonProperty(value="usage") AnthropicUsage usage, @JsonProperty(value="amazon-bedrock-invocationMetrics") AbstractBedrockApi.AmazonBedrockInvocationMetrics amazonBedrockInvocationMetrics) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record AnthropicChatStreamingResponse(@JsonProperty(value="type") StreamingType type, @JsonProperty(value="message") AnthropicChatResponse message, @JsonProperty(value="index") Integer index, @JsonProperty(value="content_block") MediaContent contentBlock, @JsonProperty(value="delta") Delta delta, @JsonProperty(value="usage") AnthropicUsage usage, @JsonProperty(value="amazon-bedrock-invocationMetrics") AbstractBedrockApi.AmazonBedrockInvocationMetrics amazonBedrockInvocationMetrics) {

        public static enum StreamingType {
            MESSAGE_START,
            CONTENT_BLOCK_START,
            PING,
            CONTENT_BLOCK_DELTA,
            CONTENT_BLOCK_STOP,
            MESSAGE_DELTA,
            MESSAGE_STOP;

        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Delta(@JsonProperty(value="type") String type, @JsonProperty(value="text") String text, @JsonProperty(value="stop_reason") String stopReason, @JsonProperty(value="stop_sequence") String stopSequence) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record AnthropicChatRequest(@JsonProperty(value="messages") List<ChatCompletionMessage> messages, @JsonProperty(value="system") String system, @JsonProperty(value="temperature") Float temperature, @JsonProperty(value="max_tokens") Integer maxTokens, @JsonProperty(value="top_k") Integer topK, @JsonProperty(value="top_p") Float topP, @JsonProperty(value="stop_sequences") List<String> stopSequences, @JsonProperty(value="anthropic_version") String anthropicVersion) {
        public static Builder builder(List<ChatCompletionMessage> messages) {
            return new Builder(messages);
        }

        public static class Builder {
            private final List<ChatCompletionMessage> messages;
            private String system;
            private Float temperature;
            private Integer maxTokens;
            private Integer topK;
            private Float topP;
            private List<String> stopSequences;
            private String anthropicVersion;

            private Builder(List<ChatCompletionMessage> messages) {
                this.messages = messages;
            }

            public Builder withSystem(String system) {
                this.system = system;
                return this;
            }

            public Builder withTemperature(Float temperature) {
                this.temperature = temperature;
                return this;
            }

            public Builder withMaxTokens(Integer maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            public Builder withTopK(Integer topK) {
                this.topK = topK;
                return this;
            }

            public Builder withTopP(Float tpoP) {
                this.topP = tpoP;
                return this;
            }

            public Builder withStopSequences(List<String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            public Builder withAnthropicVersion(String anthropicVersion) {
                this.anthropicVersion = anthropicVersion;
                return this;
            }

            public AnthropicChatRequest build() {
                return new AnthropicChatRequest(this.messages, this.system, this.temperature, this.maxTokens, this.topK, this.topP, this.stopSequences, this.anthropicVersion);
            }
        }
    }

    public static enum AnthropicChatModel implements ChatModelDescription
    {
        CLAUDE_INSTANT_V1("anthropic.claude-instant-v1"),
        CLAUDE_V2("anthropic.claude-v2"),
        CLAUDE_V21("anthropic.claude-v2:1"),
        CLAUDE_V3_SONNET("anthropic.claude-3-sonnet-20240229-v1:0"),
        CLAUDE_V3_HAIKU("anthropic.claude-3-haiku-20240307-v1:0"),
        CLAUDE_V3_OPUS("anthropic.claude-3-opus-20240229-v1:0"),
        CLAUDE_V3_5_SONNET("anthropic.claude-3-5-sonnet-20240620-v1:0");

        private final String id;

        public String id() {
            return this.id;
        }

        private AnthropicChatModel(String value) {
            this.id = value;
        }

        public String getName() {
            return this.id;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record AnthropicUsage(@JsonProperty(value="input_tokens") Integer inputTokens, @JsonProperty(value="output_tokens") Integer outputTokens) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionMessage(@JsonProperty(value="content") List<MediaContent> content, @JsonProperty(value="role") Role role) {

        public static enum Role {
            USER,
            ASSISTANT;

        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record MediaContent(@JsonProperty(value="type") Type type, @JsonProperty(value="source") Source source, @JsonProperty(value="text") String text, @JsonProperty(value="index") Integer index) {
        public MediaContent(String mediaType, String data) {
            this(new Source(mediaType, data));
        }

        public MediaContent(Source source) {
            this(Type.IMAGE, source, null, null);
        }

        public MediaContent(String text) {
            this(Type.TEXT, null, text, null);
        }

        public static enum Type {
            TEXT,
            IMAGE;

        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Source(@JsonProperty(value="type") String type, @JsonProperty(value="media_type") String mediaType, @JsonProperty(value="data") String data) {
            public Source(String mediaType, String data) {
                this("base64", mediaType, data);
            }
        }
    }
}

