/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.anthropic3;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.ai.bedrock.anthropic3.Anthropic3ChatOptions;
import org.springframework.ai.bedrock.anthropic3.api.Anthropic3ChatBedrockApi;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.model.StreamingChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.Content;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public class BedrockAnthropic3ChatModel
implements ChatModel,
StreamingChatModel {
    private final Anthropic3ChatBedrockApi anthropicChatApi;
    private final Anthropic3ChatOptions defaultOptions;

    public BedrockAnthropic3ChatModel(Anthropic3ChatBedrockApi chatApi) {
        this(chatApi, Anthropic3ChatOptions.builder().withTemperature(Float.valueOf(0.8f)).withMaxTokens(500).withTopK(10).withAnthropicVersion("bedrock-2023-05-31").build());
    }

    public BedrockAnthropic3ChatModel(Anthropic3ChatBedrockApi chatApi, Anthropic3ChatOptions options) {
        this.anthropicChatApi = chatApi;
        this.defaultOptions = options;
    }

    public ChatResponse call(Prompt prompt) {
        Anthropic3ChatBedrockApi.AnthropicChatRequest request = this.createRequest(prompt);
        Anthropic3ChatBedrockApi.AnthropicChatResponse response = this.anthropicChatApi.chatCompletion(request);
        List<Generation> generations = response.content().stream().map(content -> new Generation(content.text(), Map.of()).withGenerationMetadata(ChatGenerationMetadata.from((String)response.stopReason(), null))).toList();
        return new ChatResponse(generations);
    }

    public Flux<ChatResponse> stream(Prompt prompt) {
        Anthropic3ChatBedrockApi.AnthropicChatRequest request = this.createRequest(prompt);
        Flux<Anthropic3ChatBedrockApi.AnthropicChatStreamingResponse> fluxResponse = this.anthropicChatApi.chatCompletionStream(request);
        AtomicReference<Integer> inputTokens = new AtomicReference<Integer>(0);
        return fluxResponse.map(response -> {
            if (response.type() == Anthropic3ChatBedrockApi.AnthropicChatStreamingResponse.StreamingType.MESSAGE_START) {
                inputTokens.set(response.message().usage().inputTokens());
            }
            String content = response.type() == Anthropic3ChatBedrockApi.AnthropicChatStreamingResponse.StreamingType.CONTENT_BLOCK_DELTA ? response.delta().text() : "";
            Generation generation = new Generation(content);
            if (response.type() == Anthropic3ChatBedrockApi.AnthropicChatStreamingResponse.StreamingType.MESSAGE_DELTA) {
                generation = generation.withGenerationMetadata(ChatGenerationMetadata.from((String)response.delta().stopReason(), (Object)new Anthropic3ChatBedrockApi.AnthropicUsage((Integer)inputTokens.get(), response.usage().outputTokens())));
            }
            return new ChatResponse(List.of(generation));
        });
    }

    Anthropic3ChatBedrockApi.AnthropicChatRequest createRequest(Prompt prompt) {
        Anthropic3ChatBedrockApi.AnthropicChatRequest request = Anthropic3ChatBedrockApi.AnthropicChatRequest.builder(this.toAnthropicMessages(prompt)).withSystem(this.toAnthropicSystemContext(prompt)).build();
        if (this.defaultOptions != null) {
            request = (Anthropic3ChatBedrockApi.AnthropicChatRequest)ModelOptionsUtils.merge((Object)request, (Object)this.defaultOptions, Anthropic3ChatBedrockApi.AnthropicChatRequest.class);
        }
        if (prompt.getOptions() != null) {
            Anthropic3ChatOptions updatedRuntimeOptions = (Anthropic3ChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, Anthropic3ChatOptions.class);
            request = (Anthropic3ChatBedrockApi.AnthropicChatRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, Anthropic3ChatBedrockApi.AnthropicChatRequest.class);
        }
        return request;
    }

    private String toAnthropicSystemContext(Prompt prompt) {
        return prompt.getInstructions().stream().filter(m -> m.getMessageType() == MessageType.SYSTEM).map(Content::getContent).collect(Collectors.joining(System.lineSeparator()));
    }

    private List<Anthropic3ChatBedrockApi.ChatCompletionMessage> toAnthropicMessages(Prompt prompt) {
        return prompt.getInstructions().stream().filter(m -> m.getMessageType() == MessageType.USER || m.getMessageType() == MessageType.ASSISTANT).map(message -> {
            UserMessage userMessage;
            ArrayList<Anthropic3ChatBedrockApi.MediaContent> contents = new ArrayList<Anthropic3ChatBedrockApi.MediaContent>(List.of(new Anthropic3ChatBedrockApi.MediaContent(message.getContent())));
            if (message instanceof UserMessage && !CollectionUtils.isEmpty((Collection)(userMessage = (UserMessage)message).getMedia())) {
                List<Anthropic3ChatBedrockApi.MediaContent> mediaContent = userMessage.getMedia().stream().map(media -> new Anthropic3ChatBedrockApi.MediaContent(media.getMimeType().toString(), this.fromMediaData(media.getData()))).toList();
                contents.addAll(mediaContent);
            }
            return new Anthropic3ChatBedrockApi.ChatCompletionMessage(contents, Anthropic3ChatBedrockApi.ChatCompletionMessage.Role.valueOf(message.getMessageType().name()));
        }).toList();
    }

    private String fromMediaData(Object mediaData) {
        if (mediaData instanceof byte[]) {
            byte[] bytes = (byte[])mediaData;
            return Base64.getEncoder().encodeToString(bytes);
        }
        if (mediaData instanceof String) {
            String text = (String)mediaData;
            return text;
        }
        throw new IllegalArgumentException("Unsupported media data type: " + mediaData.getClass().getSimpleName());
    }

    public ChatOptions getDefaultOptions() {
        return Anthropic3ChatOptions.fromOptions(this.defaultOptions);
    }
}

