/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.bedrockknowledgebase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jspecify.annotations.Nullable;
import org.springframework.ai.document.DocumentMetadata;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.VectorStore;
import org.springframework.ai.vectorstore.bedrockknowledgebase.BedrockKnowledgeBaseFilterExpressionConverter;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.util.Assert;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeClient;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseRetrievalResult;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalFilter;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalResultContent;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalResultContentColumn;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalResultLocation;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.SearchType;
import software.amazon.awssdk.services.bedrockagentruntime.model.VectorSearchBedrockRerankingConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.VectorSearchBedrockRerankingModelConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.VectorSearchRerankingConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.VectorSearchRerankingConfigurationType;

public final class BedrockKnowledgeBaseVectorStore
implements VectorStore {
    public static final int DEFAULT_TOP_K = 5;
    public static final double DEFAULT_SIMILARITY_THRESHOLD = 0.0;
    private final BedrockAgentRuntimeClient client;
    private final String knowledgeBaseId;
    private final int defaultTopK;
    private final double defaultSimilarityThreshold;
    private final @Nullable SearchType searchType;
    private final @Nullable String rerankingModelArn;
    private final BedrockKnowledgeBaseFilterExpressionConverter filterConverter;

    private BedrockKnowledgeBaseVectorStore(Builder builder) {
        this.client = builder.client;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.defaultTopK = builder.topK;
        this.defaultSimilarityThreshold = builder.similarityThreshold;
        this.searchType = builder.searchType;
        this.rerankingModelArn = builder.rerankingModelArn;
        this.filterConverter = builder.filterConverter != null ? builder.filterConverter : new BedrockKnowledgeBaseFilterExpressionConverter();
    }

    public static Builder builder(BedrockAgentRuntimeClient client, String knowledgeBaseId) {
        return new Builder(client, knowledgeBaseId);
    }

    public void add(List<org.springframework.ai.document.Document> documents) {
        throw new UnsupportedOperationException("Documents are ingested via data source sync, not direct add.");
    }

    public void delete(List<String> idList) {
        throw new UnsupportedOperationException("Documents are managed via data source, not direct delete.");
    }

    public void delete(Filter.Expression filterExpression) {
        throw new UnsupportedOperationException("Documents are managed via data source, not direct delete.");
    }

    public List<org.springframework.ai.document.Document> similaritySearch(SearchRequest request) {
        RetrieveResponse response;
        Assert.notNull((Object)request, (String)"SearchRequest must not be null");
        Assert.hasText((String)request.getQuery(), (String)"Query must not be empty");
        int topK = request.getTopK() > 0 ? request.getTopK() : this.defaultTopK;
        double threshold = request.getSimilarityThreshold() >= 0.0 ? request.getSimilarityThreshold() : this.defaultSimilarityThreshold;
        RetrievalFilter bedrockFilter = null;
        if (request.hasFilterExpression()) {
            Assert.state((request.getFilterExpression() != null ? 1 : 0) != 0, (String)"filterExpression should not be null");
            bedrockFilter = this.filterConverter.convertExpression(request.getFilterExpression());
        }
        List<Object> allDocuments = new ArrayList<org.springframework.ai.document.Document>();
        String nextToken = null;
        do {
            response = this.executeRetrieve(request.getQuery(), topK, bedrockFilter, nextToken);
            List<org.springframework.ai.document.Document> pageDocuments = response.retrievalResults().stream().filter(r -> r.score() != null && r.score() >= threshold).map(this::toDocument).toList();
            allDocuments.addAll(pageDocuments);
        } while ((nextToken = response.nextToken()) != null && allDocuments.size() < topK);
        if (allDocuments.size() > topK) {
            allDocuments = allDocuments.subList(0, topK);
        }
        return allDocuments;
    }

    private RetrieveResponse executeRetrieve(String query, int topK, @Nullable RetrievalFilter filter, @Nullable String nextToken) {
        RetrieveRequest.Builder requestBuilder = RetrieveRequest.builder().knowledgeBaseId(this.knowledgeBaseId).retrievalQuery(q -> q.text(query));
        requestBuilder.retrievalConfiguration(config -> config.vectorSearchConfiguration(vs -> {
            vs.numberOfResults(Integer.valueOf(topK));
            if (filter != null) {
                vs.filter(filter);
            }
            if (this.searchType != null) {
                vs.overrideSearchType(this.searchType);
            }
            if (this.rerankingModelArn != null) {
                vs.rerankingConfiguration(this.buildRerankingConfig());
            }
        }));
        if (nextToken != null) {
            requestBuilder.nextToken(nextToken);
        }
        return this.client.retrieve((RetrieveRequest)requestBuilder.build());
    }

    private VectorSearchRerankingConfiguration buildRerankingConfig() {
        VectorSearchRerankingConfigurationType type = VectorSearchRerankingConfigurationType.BEDROCK_RERANKING_MODEL;
        VectorSearchBedrockRerankingModelConfiguration modelConfig = (VectorSearchBedrockRerankingModelConfiguration)VectorSearchBedrockRerankingModelConfiguration.builder().modelArn(this.rerankingModelArn).build();
        VectorSearchBedrockRerankingConfiguration bedrockConfig = (VectorSearchBedrockRerankingConfiguration)VectorSearchBedrockRerankingConfiguration.builder().modelConfiguration(modelConfig).build();
        return (VectorSearchRerankingConfiguration)VectorSearchRerankingConfiguration.builder().type(type).bedrockRerankingConfiguration(bedrockConfig).build();
    }

    org.springframework.ai.document.Document toDocument(KnowledgeBaseRetrievalResult result) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        Double score = result.score();
        if (score != null) {
            metadata.put(DocumentMetadata.DISTANCE.value(), 1.0 - score);
        } else {
            score = 0.0;
        }
        this.extractLocationMetadata(result.location(), metadata);
        if (result.metadata() != null) {
            result.metadata().forEach((key, docValue) -> {
                if (docValue != null) {
                    metadata.put((String)key, this.documentValueToObject((Document)docValue));
                }
            });
        }
        String text = this.extractTextContent(result);
        return org.springframework.ai.document.Document.builder().id(UUID.randomUUID().toString()).text(text).metadata(metadata).score(score).build();
    }

    private void extractLocationMetadata(@Nullable RetrievalResultLocation loc, Map<String, Object> metadata) {
        if (loc == null) {
            return;
        }
        metadata.put("locationType", loc.typeAsString());
        if (loc.s3Location() != null) {
            metadata.put("source", loc.s3Location().uri());
        } else if (loc.confluenceLocation() != null) {
            metadata.put("source", loc.confluenceLocation().url());
        } else if (loc.sharePointLocation() != null) {
            metadata.put("source", loc.sharePointLocation().url());
        } else if (loc.salesforceLocation() != null) {
            metadata.put("source", loc.salesforceLocation().url());
        } else if (loc.webLocation() != null) {
            metadata.put("source", loc.webLocation().url());
        } else if (loc.kendraDocumentLocation() != null) {
            metadata.put("source", loc.kendraDocumentLocation().uri());
        } else if (loc.sqlLocation() != null) {
            metadata.put("source", loc.sqlLocation().query());
            metadata.put("sourceType", "SQL");
        } else if (loc.customDocumentLocation() != null) {
            metadata.put("source", loc.customDocumentLocation().id());
            metadata.put("sourceType", "CUSTOM");
        }
    }

    private String extractTextContent(KnowledgeBaseRetrievalResult result) {
        if (result.content() == null) {
            return "";
        }
        RetrievalResultContent content = result.content();
        if (content.text() != null) {
            return content.text();
        }
        if (content.row() != null && !content.row().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (RetrievalResultContentColumn cell : content.row()) {
                if (cell == null || cell.columnName() == null || cell.columnValue() == null) continue;
                sb.append(cell.columnName()).append(": ").append(cell.columnValue()).append("\n");
            }
            return sb.toString().trim();
        }
        return "";
    }

    private Object documentValueToObject(Document doc) {
        if (doc.isString()) {
            return doc.asString();
        }
        if (doc.isNumber()) {
            return doc.asNumber();
        }
        if (doc.isBoolean()) {
            return doc.asBoolean();
        }
        if (doc.isList()) {
            return doc.asList().stream().map(this::documentValueToObject).toList();
        }
        if (doc.isMap()) {
            HashMap map = new HashMap();
            doc.asMap().forEach((k, v) -> map.put(k, this.documentValueToObject((Document)v)));
            return map;
        }
        return doc.toString();
    }

    public String getName() {
        return "BedrockKnowledgeBaseVectorStore";
    }

    public <T> Optional<T> getNativeClient() {
        BedrockAgentRuntimeClient nativeClient = this.client;
        return Optional.of(nativeClient);
    }

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public static final class Builder {
        private final BedrockAgentRuntimeClient client;
        private final String knowledgeBaseId;
        private int topK = 5;
        private double similarityThreshold = 0.0;
        private @Nullable SearchType searchType;
        private @Nullable String rerankingModelArn;
        private @Nullable BedrockKnowledgeBaseFilterExpressionConverter filterConverter;

        private Builder(BedrockAgentRuntimeClient client, String knowledgeBaseId) {
            Assert.notNull((Object)client, (String)"BedrockAgentRuntimeClient must not be null");
            Assert.hasText((String)knowledgeBaseId, (String)"Knowledge Base ID must not be empty");
            this.client = client;
            this.knowledgeBaseId = knowledgeBaseId;
        }

        public Builder topK(int topK) {
            Assert.isTrue((topK > 0 ? 1 : 0) != 0, (String)"topK must be positive");
            this.topK = topK;
            return this;
        }

        public Builder similarityThreshold(double similarityThreshold) {
            Assert.isTrue((similarityThreshold >= 0.0 && similarityThreshold <= 1.0 ? 1 : 0) != 0, (String)"similarityThreshold must be between 0.0 and 1.0");
            this.similarityThreshold = similarityThreshold;
            return this;
        }

        public Builder searchType(@Nullable SearchType searchType) {
            this.searchType = searchType;
            return this;
        }

        public Builder rerankingModelArn(@Nullable String modelArn) {
            this.rerankingModelArn = modelArn;
            return this;
        }

        public Builder filterConverter(@Nullable BedrockKnowledgeBaseFilterExpressionConverter filterConverter) {
            this.filterConverter = filterConverter;
            return this;
        }

        public BedrockKnowledgeBaseVectorStore build() {
            return new BedrockKnowledgeBaseVectorStore(this);
        }
    }
}

