/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.bedrockknowledgebase;

import java.util.List;
import java.util.Objects;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterHelper;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.services.bedrockagentruntime.model.FilterAttribute;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievalFilter;

public class BedrockKnowledgeBaseFilterExpressionConverter {
    public RetrievalFilter convertExpression(Filter.Expression expression) {
        return this.convert(expression);
    }

    private RetrievalFilter convert(Filter.Expression expression) {
        Filter.ExpressionType type = expression.type();
        return switch (type) {
            case Filter.ExpressionType.AND -> this.convertAnd(expression);
            case Filter.ExpressionType.OR -> this.convertOr(expression);
            case Filter.ExpressionType.NOT -> this.convertNot(expression);
            case Filter.ExpressionType.EQ -> this.buildComparison(expression, ComparisonOp.EQ);
            case Filter.ExpressionType.NE -> this.buildComparison(expression, ComparisonOp.NE);
            case Filter.ExpressionType.GT -> this.buildComparison(expression, ComparisonOp.GT);
            case Filter.ExpressionType.GTE -> this.buildComparison(expression, ComparisonOp.GTE);
            case Filter.ExpressionType.LT -> this.buildComparison(expression, ComparisonOp.LT);
            case Filter.ExpressionType.LTE -> this.buildComparison(expression, ComparisonOp.LTE);
            case Filter.ExpressionType.IN -> this.convertIn(expression);
            case Filter.ExpressionType.NIN -> this.convertNotIn(expression);
            default -> throw new UnsupportedOperationException("Filter type not supported: " + String.valueOf(type));
        };
    }

    private RetrievalFilter convertAnd(Filter.Expression expression) {
        Filter.Operand leftOp = Objects.requireNonNull(expression.left(), "left operand");
        Filter.Operand rightOp = Objects.requireNonNull(expression.right(), "right operand");
        RetrievalFilter left = this.convert(this.asExpression(leftOp));
        RetrievalFilter right = this.convert(this.asExpression(rightOp));
        return (RetrievalFilter)RetrievalFilter.builder().andAll(new RetrievalFilter[]{left, right}).build();
    }

    private RetrievalFilter convertOr(Filter.Expression expression) {
        Filter.Operand leftOp = Objects.requireNonNull(expression.left(), "left operand");
        Filter.Operand rightOp = Objects.requireNonNull(expression.right(), "right operand");
        RetrievalFilter left = this.convert(this.asExpression(leftOp));
        RetrievalFilter right = this.convert(this.asExpression(rightOp));
        return (RetrievalFilter)RetrievalFilter.builder().orAll(new RetrievalFilter[]{left, right}).build();
    }

    private RetrievalFilter convertNot(Filter.Expression expression) {
        Filter.Operand negated = FilterHelper.negate((Filter.Operand)expression);
        if (negated instanceof Filter.Expression) {
            Filter.Expression negatedExpr = (Filter.Expression)negated;
            return this.convert(negatedExpr);
        }
        throw new IllegalArgumentException("NOT operator negation failed for expression type: " + String.valueOf(expression.type()) + ". Operand: " + String.valueOf(negated));
    }

    private RetrievalFilter buildComparison(Filter.Expression exp, ComparisonOp op) {
        Filter.Operand leftOp = Objects.requireNonNull(exp.left(), "left operand");
        Filter.Operand rightOp = Objects.requireNonNull(exp.right(), "right operand");
        String key = ((Filter.Key)leftOp).key();
        Object value = this.extractValue(rightOp);
        FilterAttribute attr = this.createFilterAttribute(key, value);
        return switch (op.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> (RetrievalFilter)RetrievalFilter.builder().equalsValue(attr).build();
            case 1 -> (RetrievalFilter)RetrievalFilter.builder().notEquals(attr).build();
            case 2 -> (RetrievalFilter)RetrievalFilter.builder().greaterThan(attr).build();
            case 3 -> (RetrievalFilter)RetrievalFilter.builder().greaterThanOrEquals(attr).build();
            case 4 -> (RetrievalFilter)RetrievalFilter.builder().lessThan(attr).build();
            case 5 -> (RetrievalFilter)RetrievalFilter.builder().lessThanOrEquals(attr).build();
        };
    }

    private RetrievalFilter convertIn(Filter.Expression expression) {
        Filter.Operand leftOp = Objects.requireNonNull(expression.left(), "left operand");
        Filter.Operand rightOp = Objects.requireNonNull(expression.right(), "right operand");
        String key = ((Filter.Key)leftOp).key();
        List<?> values = this.extractListValue(rightOp);
        List<Document> docs = values.stream().map(this::toDocument).toList();
        FilterAttribute attr = (FilterAttribute)FilterAttribute.builder().key(key).value(Document.fromList(docs)).build();
        return (RetrievalFilter)RetrievalFilter.builder().in(attr).build();
    }

    private RetrievalFilter convertNotIn(Filter.Expression expression) {
        Filter.Operand leftOp = Objects.requireNonNull(expression.left(), "left operand");
        Filter.Operand rightOp = Objects.requireNonNull(expression.right(), "right operand");
        String key = ((Filter.Key)leftOp).key();
        List<?> values = this.extractListValue(rightOp);
        List<Document> docs = values.stream().map(this::toDocument).toList();
        FilterAttribute attr = (FilterAttribute)FilterAttribute.builder().key(key).value(Document.fromList(docs)).build();
        return (RetrievalFilter)RetrievalFilter.builder().notIn(attr).build();
    }

    private FilterAttribute createFilterAttribute(String key, Object value) {
        return (FilterAttribute)FilterAttribute.builder().key(key).value(this.toDocument(value)).build();
    }

    private Filter.Expression asExpression(Filter.Operand operand) {
        if (operand instanceof Filter.Expression) {
            Filter.Expression expr = (Filter.Expression)operand;
            return expr;
        }
        throw new IllegalArgumentException("Expected Expression but got: " + String.valueOf(operand.getClass()));
    }

    private Object extractValue(Filter.Operand operand) {
        if (operand instanceof Filter.Value) {
            Filter.Value value = (Filter.Value)operand;
            return value.value();
        }
        throw new IllegalArgumentException("Expected Value but got: " + String.valueOf(operand.getClass()));
    }

    private List<?> extractListValue(Filter.Operand operand) {
        Object value = this.extractValue(operand);
        if (value instanceof List) {
            return (List)value;
        }
        throw new IllegalArgumentException("Expected List for IN/NIN but got: " + String.valueOf(value.getClass()));
    }

    private Document toDocument(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            return Document.fromString((String)s);
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            return Document.fromNumber((String)n.toString());
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return Document.fromBoolean((boolean)b);
        }
        return Document.fromString((String)value.toString());
    }

    private static enum ComparisonOp {
        EQ,
        NE,
        GT,
        GTE,
        LT,
        LTE;

    }
}

