/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.bedrock.converse.api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.ModelOptions;
import org.springframework.ai.model.ModelOptionsUtils;
import software.amazon.awssdk.core.document.Document;

public final class ConverseApiUtils {
    private ConverseApiUtils() {
    }

    public static Document getChatOptionsAdditionalModelRequestFields(ChatOptions defaultOptions, ModelOptions promptOptions) {
        if (defaultOptions == null && promptOptions == null) {
            return null;
        }
        HashMap attributes = new HashMap();
        if (defaultOptions != null) {
            attributes.putAll(ModelOptionsUtils.objectToMap((Object)defaultOptions));
        }
        if (promptOptions != null) {
            if (promptOptions instanceof ChatOptions) {
                ChatOptions runtimeOptions = (ChatOptions)promptOptions;
                attributes.putAll(ModelOptionsUtils.objectToMap((Object)runtimeOptions));
            } else {
                throw new IllegalArgumentException("Prompt options are not of type ChatOptions:" + promptOptions.getClass().getSimpleName());
            }
        }
        attributes.remove("model");
        attributes.remove("proxyToolCalls");
        attributes.remove("functions");
        attributes.remove("toolContext");
        attributes.remove("toolCallbacks");
        attributes.remove("toolCallbacks");
        attributes.remove("toolNames");
        attributes.remove("internalToolExecutionEnabled");
        attributes.remove("temperature");
        attributes.remove("topK");
        attributes.remove("stopSequences");
        attributes.remove("maxTokens");
        attributes.remove("topP");
        return ConverseApiUtils.convertObjectToDocument(attributes);
    }

    public static Document convertObjectToDocument(Object value) {
        if (value == null) {
            return Document.fromNull();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return Document.fromString((String)stringValue);
        }
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return Document.fromBoolean((boolean)booleanValue);
        }
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            return Document.fromNumber((int)integerValue);
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return Document.fromNumber((long)longValue);
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return Document.fromNumber((float)floatValue.floatValue());
        }
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return Document.fromNumber((double)doubleValue);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            return Document.fromNumber((BigDecimal)bigDecimalValue);
        }
        if (value instanceof BigInteger) {
            BigInteger bigIntegerValue = (BigInteger)value;
            return Document.fromNumber((BigInteger)bigIntegerValue);
        }
        if (value instanceof List) {
            List listValue = (List)value;
            return Document.fromList(listValue.stream().map(v -> ConverseApiUtils.convertObjectToDocument(v)).toList());
        }
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            return ConverseApiUtils.convertMapToDocument(mapValue);
        }
        throw new IllegalArgumentException("Unsupported value type:" + value.getClass().getSimpleName());
    }

    public static Map<String, String> getRequestMetadata(Map<String, Object> metadata) {
        if (metadata.isEmpty()) {
            return Map.of();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            result.put(key, value.toString());
        }
        return result;
    }

    private static Document convertMapToDocument(Map<String, Object> value) {
        Map<String, Document> attr = value.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ConverseApiUtils.convertObjectToDocument(e.getValue())));
        return Document.fromMap(attr);
    }
}

